﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testVi_MemoryManagement.h"

#include <cstdlib>
#include <nv/nv_MemoryManagement.h>

namespace nnt{ namespace vi{

    namespace {
        static const size_t DonateMemorySize = 1024 * 1024;

        bool IsMemoryInitialized = false;

        void* GraphicsAllocate(size_t size, size_t alignment, void*)
        {
            //NN_LOG("gr alloc\n");
            return aligned_alloc(alignment, size);
        }
        void GraphicsFree(void* p, void*)
        {
            //NN_LOG("gr free\n");
            free(p);
        }
        void* GraphicsReallocate(void* p, size_t size, void*)
        {
            //NN_LOG("gr realloc\n");
            return realloc(p, size);
        }
    }

    void SetupMemory() NN_NOEXCEPT
    {
        if(IsMemoryInitialized)
        {
            return;
        }

        nv::SetGraphicsAllocator(GraphicsAllocate, GraphicsFree, GraphicsReallocate, nullptr);
        nv::SetGraphicsDevtoolsAllocator(GraphicsAllocate, GraphicsFree, GraphicsReallocate, nullptr);
        nv::InitializeGraphics(aligned_alloc(4 * 1024, DonateMemorySize), DonateMemorySize);

        IsMemoryInitialized = true;
    }



}}
