﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/vi.h>
#include <nn/vi.private.h>
#include <nn/vi/manager/vi_Manager.h>
#include <nn/applet/applet.h>

#include <nnt.h>
#include "testVi_MemoryManagement.h"

namespace nn{ namespace vi{ namespace dev{
    extern LayerId g_ExternalLayerId;
    extern nn::applet::AppletResourceUserId g_Aruid;
}}}


TEST(testVi, ManagerApi)
{
    nnt::vi::SetupMemory();

    NN_LOG("Initialize client\n");
    nn::vi::Initialize();

    NN_LOG("Intialize manager\n");
    nn::vi::ProxyName proxyName = { "dispmgr" };
    nn::vi::manager::DisplayManagerService mgrSrv;
    mgrSrv.Initialize(nn::vi::PolicyLevel_Composition, &proxyName);
    NN_UTIL_SCOPE_EXIT{
        mgrSrv.Finalize();
    };

    nn::applet::AppletResourceUserId appAruid = nn::applet::GetAppletResourceUserId();
    NN_LOG("My aruid = %016llX\n", appAruid.lower);

    // create layer by manager
    nn::vi::DisplayId mgrDisplayId = {};
    nn::vi::LayerId   mgrLayerId = {};
    {
        mgrSrv.GetApplicationDisplayService()->OpenDefaultDisplay(&mgrDisplayId);
        int64_t width = {};
        int64_t height = {};
        nn::vi::LayerSettings settings;
        nn::vi::SetLayerSettingsDefaults(&settings);
        mgrSrv.GetApplicationDisplayService()->GetDisplayResolution(&width, &height, mgrDisplayId);
        mgrSrv.GetManagerDisplayService()->CreateManagedLayer(&mgrLayerId, mgrDisplayId, settings._storage[0], appAruid);
    }

    nn::vi::dev::g_ExternalLayerId = mgrLayerId;

    // open layer by application
    nn::vi::Display* appDisplay = {};
    nn::vi::Layer* appLayer = {};
    {
        nn::vi::OpenDefaultDisplay(&appDisplay);
        int width = {};
        int height = {};
        nn::vi::GetDisplayResolution(&width, &height, appDisplay);
        nn::vi::CreateLayer(&appLayer, appDisplay);
    }

    // set layer z by manager and get it by application
    {
        int64_t newZValue = 100;
        mgrSrv.GetSystemDisplayService()->SetLayerZ(mgrLayerId, newZValue);
        int z = {};
        nn::vi::GetLayerZ(&z, appLayer);
        EXPECT_EQ(z, static_cast<int>(newZValue));
    }

    // set layer z by application and get it by manager
    {
        int newZValue = 500;
        nn::vi::SetLayerZ(appLayer, newZValue);
        int64_t z = {};
        mgrSrv.GetSystemDisplayService()->GetLayerZ(&z, mgrLayerId);
        EXPECT_EQ(static_cast<int>(z), newZValue);
    }

    // close layer by application
    {
        nn::vi::DestroyLayer(appLayer);
    }

    // destroy layer by manager
    {
        mgrSrv.GetManagerDisplayService()->DestroyManagedLayer(mgrLayerId);
    }

    nn::vi::Finalize();
}
