﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nnt/viUtil/testVi_Profiler.h>

void nnt::vi::util::TestVsyncSignals(int iterations, nn::os::SystemEvent* pAppVsync, nn::os::SystemEvent* pDebugVsync) NN_NOEXCEPT
{
    nn::os::MultiWaitHolderType appVsyncHolder;
    nn::os::InitializeMultiWaitHolder(&appVsyncHolder, pAppVsync->GetBase());

    nn::os::MultiWaitHolderType debugVsyncHolder;
    nn::os::InitializeMultiWaitHolder(&debugVsyncHolder, pDebugVsync->GetBase());

    nn::os::MultiWaitType waiter;
    nn::os::InitializeMultiWait(&waiter);
    nn::os::LinkMultiWaitHolder(&waiter, &appVsyncHolder);
    nn::os::LinkMultiWaitHolder(&waiter, &debugVsyncHolder);

    NN_UTIL_SCOPE_EXIT
    {
        nn::os::UnlinkMultiWaitHolder(&appVsyncHolder);
        nn::os::FinalizeMultiWaitHolder(&appVsyncHolder);
        nn::os::UnlinkMultiWaitHolder(&debugVsyncHolder);
        nn::os::FinalizeMultiWaitHolder(&debugVsyncHolder);
        nn::os::FinalizeMultiWait(&waiter);
    };

    pAppVsync->Clear();
    pDebugVsync->Clear();

    for( int i = 0; i < iterations; ++i )
    {
        bool isVsyncSignalled = false;
        bool isVsyncDebugSignalled = false;

        while( !isVsyncSignalled || !isVsyncDebugSignalled )
        {
            nn::os::MultiWaitHolderType* signalled = nn::os::TimedWaitAny(&waiter, nn::TimeSpan::FromSeconds(1));

            if( signalled == nullptr )
            {
                FAIL();
            }

            if( signalled == &appVsyncHolder )
            {
                if( isVsyncSignalled )
                {
                    // already signalled but haven't received the debug event signal yet...
                    FAIL();
                }

                isVsyncSignalled = true;
                pAppVsync->Clear();
            }
            else
            {
                if( signalled == &debugVsyncHolder )
                {
                    if( isVsyncDebugSignalled )
                    {
                        // already signalled but haven't received the real vsync event signal yet...
                        FAIL();
                    }

                    isVsyncDebugSignalled = true;
                    pDebugVsync->Clear();
                }
            }
        }
    }
}
