﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/settings/system/settings_Tv.h>
#include <nnt/viUtil/testVi_EdidFixture.h>

// 480p only EDID
static const std::uint8_t s_pEdidRaw[] =
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
    0x4D, 0x10, 0xDB, 0x0F, 0x00, 0x00, 0x00, 0x00,
    0xFF, 0x11, 0x01, 0x03, 0x80, 0x52, 0x2E, 0x78,
    0x2A, 0x1B, 0xBE, 0xA2, 0x55, 0x34, 0xB3, 0x26,
    0x14, 0x4A, 0x52, 0x20, 0x00, 0x00, 0x1D, 0x40,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x8F, 0x0A,
    0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10, 0x10, 0x3E,
    0x96, 0x00, 0x20, 0x58, 0x32, 0x00, 0x00, 0x18,
    0x8F, 0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10,
    0x10, 0x3E, 0x96, 0x00, 0x20, 0x58, 0x32, 0x00,
    0x00, 0x18, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x53,
    0x48, 0x41, 0x52, 0x50, 0x20, 0x48, 0x44, 0x4D,
    0x49, 0x0A, 0x20, 0x20, 0x00, 0x00, 0x00, 0xFD,
    0x00, 0x37, 0x4C, 0x0F, 0x41, 0x0B, 0x00, 0x0A,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x99,

    0x02, 0x03, 0x16, 0x71, 0x42, 0x01, 0x03, 0x23,
    0x09, 0x07, 0x01, 0x83, 0x01, 0x00, 0x00, 0x66,
    0x03, 0x0C, 0x00, 0x10, 0x00, 0x80, 0xC4, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x8F, 0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10,
    0x10, 0x3E, 0x96, 0x00, 0x20, 0x58, 0x32, 0x00,
    0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE,
};

nnt::vi::util::EdidFixture::EdidFixture() NN_NOEXCEPT
{
    WriteEdid(s_pEdidRaw, sizeof(s_pEdidRaw));
}

void nnt::vi::util::EdidFixture::WriteEdid(const std::uint8_t* pEdid, size_t size) NN_NOEXCEPT
{
    nn::settings::system::Edid edid;

    NN_ASSERT(sizeof(edid) == size);

    std::memcpy(edid.data0, pEdid, sizeof(edid.data0));
    std::memcpy(edid.data1, pEdid + sizeof(edid.data0), sizeof(edid.data1));

    nn::settings::system::SetEdid(edid);
}
