﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstdlib>
#include "glvapp_RootSurface.h"

namespace glvapp {

/**
 *  ルートサーフェイスコンテキストの定義です。
 */
RootSurfaceContext::RootSurfaceContext() NN_NOEXCEPT
    :   glv::Window( glv::glutGet( GLUT_SCREEN_WIDTH ), glv::glutGet( GLUT_SCREEN_HEIGHT ), "GlvApplication" ),
        glv::GLV()
{
    // 安全フレーム背景色
    m_RootStyle.color.back.set( 0 );
    style( &m_RootStyle );

    // ルート登録
    this->setGLV( *this );
}

RootSurfaceContext::~RootSurfaceContext() NN_NOEXCEPT
{
}

void RootSurfaceContext::OnLoopAttached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopAttached(context);
}

void RootSurfaceContext::OnLoopDetached(glv::ApplicationLoopContext& context) NN_NOEXCEPT
{
    ApplicationLoopCallback::OnLoopDetached(context);
    setFocus( nullptr );
}

const glv::RequiredRestoration RootSurfaceContext::OnLoopBeforeSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    NN_UNUSED( events );
    NN_UNUSED( context );
    // 戻り値は固定
    return glv::RequiredRestoration::RequireRestrationNothing;
}

const glv::RequiredRestoration RootSurfaceContext::OnLoopAfterSceneRenderer(glv::ApplicationLoopContext& context, const glv::HidEvents& events) NN_NOEXCEPT
{
    NN_UNUSED( events );
    NN_UNUSED( context );
    // 戻り値は固定

    glv::ApplicationFrameworkExit();
    return glv::RequiredRestoration::RequireRestrationNothing;
}

bool RootSurfaceContext::onEvent(glv::Event::t events, glv::GLV& context) NN_NOEXCEPT
{
    NN_UNUSED( events );
    NN_UNUSED( context );
    return false;
}

void RootSurfaceContext::onDraw(glv::GLV& context) NN_NOEXCEPT
{
    glv::GLV::onDraw(context);
}

} // end of namespace glvapp
