﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/edid.h>

// Kakiuchi-san's Sony Bravia
static const std::uint8_t s_pEdidRaw[] =
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x4d, 0xd9, 0x01, 0xf3, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x14, 0x01, 0x03, 0x80, 0xa0, 0x5a, 0x78,
    0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27,
    0x12, 0x48, 0x4c, 0x21, 0x08, 0x00, 0x81, 0x80,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a,
    0x80, 0x18, 0x71, 0x38, 0x2d, 0x40, 0x58, 0x2c,
    0x45, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x1e,
    0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20,
    0x6e, 0x28, 0x55, 0x00, 0x40, 0x84, 0x63, 0x00,
    0x00, 0x1e, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x3a,
    0x3e, 0x0f, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfc,
    0x00, 0x53, 0x4f, 0x4e, 0x59, 0x20, 0x54, 0x56,
    0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xae,

    0x02, 0x03, 0x25, 0xf0, 0x49, 0x10, 0x04, 0x05,
    0x03, 0x02, 0x07, 0x06, 0x20, 0x01, 0x26, 0x09,
    0x07, 0x07, 0x15, 0x07, 0x50, 0x83, 0x01, 0x00,
    0x00, 0x68, 0x03, 0x0c, 0x00, 0x10, 0x00, 0xb8,
    0x2d, 0x0f, 0xe2, 0x00, 0x7b, 0x01, 0x1d, 0x80,
    0x18, 0x71, 0x1c, 0x16, 0x20, 0x58, 0x2c, 0x25,
    0x00, 0x40, 0x84, 0x63, 0x00, 0x00, 0x9e, 0x8c,
    0x0a, 0xd0, 0x8a, 0x20, 0xe0, 0x2d, 0x10, 0x10,
    0x3e, 0x96, 0x00, 0x40, 0x84, 0x63, 0x00, 0x00,
    0x18, 0x8c, 0x0a, 0xd0, 0x8a, 0x20, 0xe0, 0x2d,
    0x10, 0x10, 0x3e, 0x96, 0x00, 0xb0, 0x84, 0x43,
    0x00, 0x00, 0x18, 0x8c, 0x0a, 0xa0, 0x14, 0x51,
    0xf0, 0x16, 0x00, 0x26, 0x7c, 0x43, 0x00, 0xb0,
    0x84, 0x43, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0,
};

TEST(RgbEdid, DisplayInfo)
{
    nn::edid::Edid edid;
    ASSERT_EQ(nn::edid::Error_None, nn::edid::OpenEdid(&edid, s_pEdidRaw, sizeof(s_pEdidRaw)));

    nn::edid::DisplayInfo display;
    nn::edid::GetDisplayInfo(&display, &edid);

    EXPECT_STREQ("SNY", display.manufacturerCode);
    EXPECT_EQ(0xF301, display.productCode);
    EXPECT_EQ(16843009, display.serialNumber);

    int date;
    EXPECT_TRUE(nn::edid::GetDisplayWeekOfManufacture(&date, &display));
    EXPECT_EQ(1, date);
    EXPECT_TRUE(nn::edid::GetDisplayYearOfManufacture(&date, &display));
    EXPECT_EQ(2010, date);

    EXPECT_EQ(nn::edid::VideoInterface_Digital, display.interfaceType);
    EXPECT_EQ(nn::edid::SyncLevel_Digital, display.sync);
    EXPECT_EQ(nn::edid::BlankLevel_Digital, display.blankType);

    EXPECT_EQ(nn::edid::ColorDepth_Undefined, display.depth);
    EXPECT_EQ(nn::edid::ColorType_Undefined, display.colorSupport);

    EXPECT_TRUE(display.contentTypes.IsAllOn());
    EXPECT_TRUE(display.syncTypes.IsAllOff());

    EXPECT_FALSE(display.isSrgbDefaultColorSpace);
    EXPECT_FALSE(display.isStandbyModeSupported);
    EXPECT_FALSE(display.isContinuousFrequency);
    EXPECT_FALSE(display.hasVsyncSerrations);
    EXPECT_FALSE(display.isStandbyModeSupported);
    EXPECT_FALSE(display.isSuspendModeSupported);
    EXPECT_FALSE(display.isVeryLowPowerSupported);
    EXPECT_FALSE(display.isYccQuantizationSelectable);
    EXPECT_TRUE(display.isRgbQuantizationSelectable);
}

TEST(RgbEdid, GetSourcePhysicalAddress)
{
    nn::edid::Edid edid;
    ASSERT_EQ(nn::edid::Error_None, nn::edid::OpenEdid(&edid, s_pEdidRaw, sizeof(s_pEdidRaw)));

    std::uint16_t address;
    ASSERT_TRUE(nn::edid::GetSourcePhysicalAddress(&address, &edid));
    EXPECT_EQ(0x1000, address);
}
