﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/edid/edid_DisplayModeInfo.h>
#include <nn/edid/edid_DisplayTimingInfo.h>
#include <nn/edid/edid_ImageSizeInfo.h>
#include <nnt/edidUtil/testEdid_FullModeInfo.h>

nnt::edid::FullModeInfo::FullModeInfo() NN_NOEXCEPT
    : pMode(nullptr)
    , pTimingInfo(nullptr)
    , pSizeInfo(nullptr)
{
}

nnt::edid::FullModeInfo::FullModeInfo(const nn::edid::DisplayModeInfo* pMode,
                                      const nn::edid::DisplayTimingInfo* pTimingInfo,
                                      const nn::edid::ImageSizeInfo* pSizeInfo) NN_NOEXCEPT
    : pMode(new nn::edid::DisplayModeInfo(*pMode))
    , pTimingInfo(nullptr)
    , pSizeInfo(nullptr)
{
    if( pTimingInfo != nullptr )
    {
        this->pTimingInfo = new nn::edid::DisplayTimingInfo(*pTimingInfo);
    }

    if( pSizeInfo != nullptr )
    {
        this->pSizeInfo = new nn::edid::ImageSizeInfo(*pSizeInfo);
    }
}

nnt::edid::FullModeInfo::FullModeInfo(FullModeInfo&& copy) NN_NOEXCEPT
    : pMode(copy.pMode)
    , pTimingInfo(copy.pTimingInfo)
    , pSizeInfo(copy.pSizeInfo)
{
    copy.pMode = nullptr;
    copy.pSizeInfo = nullptr;
    copy.pTimingInfo = nullptr;
}

nnt::edid::FullModeInfo::~FullModeInfo() NN_NOEXCEPT
{
    delete pMode;
    delete pSizeInfo;
    delete pTimingInfo;
}
