<?php

	// Get the array of file information
	$uploadedFile = $_FILES['imagefile'];

	// Verify that there were no upload-related errors
	if ($uploadedFile['error'] != UPLOAD_ERR_OK)
	{
		// Indicate upload failure somehow
		return;
	}

	// Calculate the MD5 checksum of the uploaded file
	$fileName = $uploadedFile['tmp_name'];
	$md5sum = md5_file($fileName);

	// Build a response object containing metadata
	$metadata = array(
		"md5sum" => $md5sum,
		"size" => $uploadedFile['size'],
		"filename" => $uploadedFile['name']
	);
	
	// Send the metadata back to the user agent
	header("Content-Type: application/json");
	print(json_encode($metadata, JSON_PRETTY_PRINT | JSON_FORCE_OBJECT | JSON_NUMERIC_CHECK) . "\n");

?>
