<?php
	// Get all of the request headers from Apache
	$requestHeaders = apache_request_headers();

	// Create a new XML document to return to the client
	$xml = new DOMDocument("1.0", "utf-8");
	$xml->formatOutput = true;

	$headers = $xml->createElement("RequestHeaders");
	$xml->appendChild($headers);
	
	// What HTTP method was called?
	$httpMethod = $xml->createElement("Method", $_SERVER['REQUEST_METHOD']);
	$headers->appendChild($httpMethod);
	
	// What version of the HTTP protocol
	$httpProto = $xml->createElement("Protocol", $_SERVER['SERVER_PROTOCOL']);
	$headers->appendChild($httpProto);
	
	// Output the client's IP and port
	$remoteHost = $xml->createElement("RemoteHost");
	$remoteAddress = $xml->createElement("Address", $_SERVER['REMOTE_ADDR']);
	$remoteHost->appendChild($remoteAddress);
	$remotePort = $xml->createElement("Port", $_SERVER['REMOTE_PORT']);
	$remoteHost->appendChild($remotePort);
	$headers->appendChild($remoteHost);

	// Iterate over the request headers and add them
	foreach ($requestHeaders as $header => $value)
	{
		$xmlHeader = $xml->createElement("Header");
		$headers->appendChild($xmlHeader);

		$xmlHeader->appendChild($xml->createElement("Name", $header));
		$xmlHeader->appendChild($xml->createElement("Value", $value));
	}

	// Print out the resulting XML
	setcookie("Flavor", "Peanut-Butter", 0, "/", "natf.com");
	header("Content-Type: application/xml; charset=utf-8");
	print $xml->saveXML();
?>
