﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/xcd/xcd.h>
#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)
#include "ProcessorTaskBase.h"

//============================================================
class HandAnalysisModeTestTask : public ProcessorTaskBase
{
public:
    HandAnalysisModeTestTask(const char* name, uptr arg)  // arg is unused. you can set NULL when you call the constructor.
    : ProcessorTaskBase(name, arg),
    m_State()
    {
    }

    virtual ~HandAnalysisModeTestTask()
    {}

public:
    enum
    {
        MENU_ITEM_CLUSTERING_NUM
    };

    static const char* MENU_ITEM_CLUSTERING_NAMES[MENU_ITEM_CLUSTERING_NUM];

private:
    void DrawHandAnalysis( nn::xcd::IrTeraPluginProcessorState& HandAnalysisProcessorState, IplImage* pResultImage);
    void SetDefaultHandAnalysisConfig();
    void SaveData(IplImage* pImage, nn::xcd::IrTeraPluginProcessorState& state);

protected: // you have to implement
    virtual void DoInitializeCore();
    virtual void DoFinalizeCore();
    virtual void DoCalcCore(IplImage* pImage, IplImage* pDstImage);
    virtual void DoDrawCore(IplImage* pImage);
    virtual void DoDrawMenuCore(IplImage* pImage);
    virtual void DoCalcMenuCore(int* pMenuCnt);
    virtual void DoWriteRegSettingCore(nn::xcd::IrWriteRegisterSetting& setting, int& index);
    virtual void DoSetDefaultConfigCore(ProcessorConfig& config);
    virtual void DoCreateLogFileCore();
    virtual void DoCloseLogFileCore();

private:
    nn::xcd::IrTeraPluginProcessorState m_State;
}; //HandAnalysisModeTestTask

//============================================================
