﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Time.h"

namespace test {

namespace {
//==========================================================
//! @brief 周波数を返します。Tick を時間に直すときに使用します。
s64 GetFrequency()
{
    LARGE_INTEGER freq;
    BOOL ret = QueryPerformanceFrequency(&freq);
    if (!ret)
    {
        return 1000000LL;  // 取得できないときテキトーな値
    }
    return freq.QuadPart;
} //GetFrequency
} //namespace

//==========================================================
const s64 TimeSpan::sc_Frequency = GetFrequency();  // @todo どの環境でも初期化で関数呼べたっけ(?)

//==========================================================
// TimeSpan クラス
//==========================================================

//==========================================================
void TimeSpan::SetNanoSeconds(s64 nsec)
{
    s64 nsecAbs = (nsec < 0) ? -nsec : nsec;
    s64 span = 0;
    if (nsecAbs <= LLONG_MAX / sc_Frequency)
    {
        span = nsec * sc_Frequency / 1000 / 1000 / 1000;
    }
    else if (nsecAbs <= LLONG_MAX / sc_Frequency * 1000)
    {
        span = nsec / 1000 * sc_Frequency / 1000 / 1000;
    }
    else if (nsecAbs <= LLONG_MAX / sc_Frequency * 1000 * 1000)
    {
        span = nsec / 1000 / 1000 * sc_Frequency / 1000;
    }
    else
    {
        span = nsec / 1000 / 1000 / 1000 * sc_Frequency;
    }
    m_Span = span;
} //TimeSpan::SetNanoSeconds()

//==========================================================
s64 TimeSpan::GetNanoSeconds() const
{
    s64 ret = 0;
    if (m_Span < (LLONG_MAX / 1000 / 1000 / 1000))
    {
        ret = m_Span * 1000 * 1000 * 1000 / sc_Frequency;
    }
    else if (m_Span < (LLONG_MAX / 1000 / 1000))
    {
        ret = m_Span * 1000 * 1000 / sc_Frequency * 1000;
    }
    else if (m_Span < (LLONG_MAX / 1000))
    {
        ret = m_Span * 1000 / sc_Frequency * 1000 * 1000;
    }
    else
    {
        ret = m_Span / sc_Frequency * 1000 * 1000 * 1000;
    }
    return ret;
} //TimeSpan::GetNanoSeconds()

//==========================================================
// TickTime クラス
//==========================================================

//==========================================================
void TickTime::SetCurrentCpuTime()
{
    LARGE_INTEGER now;
    QueryPerformanceCounter(&now);
    m_Tick = now.QuadPart;
} //TickTime::SetCurrentCpuTime()

} //test
