﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "test_Common.h"
#include "test_CvUtil.h"

#pragma warning(push)
#pragma warning(disable: 4668)
#include <opencv2/opencv.hpp>
#pragma warning(pop)

namespace test {

//============================================================
class TextWriter
{
public:
    TextWriter()
    : m_IsInitialized(false)
    , m_Font()
    , m_FontSize(cvSize(32, 32))
    , m_FontColor(CONST_COLOR_WHITE)
    {}

    virtual ~TextWriter()
    {}

private:
    TextWriter(const TextWriter& src);
    TextWriter& operator=(const TextWriter& rhs);

public:
    void Initialize(const CvSize& fontSize);
    void Finalize();
    void SetFontColor(const CvScalar& color)
    {
        TEST_ASSERT(m_IsInitialized);
        m_FontColor = color;
    }
    void PutText(IplImage* pDstImage, const s32 x, const s32 y, const char* fmt, ...);
    void PutTextCore(IplImage* pDstImage, const s32 x, const s32 y, const char* text);

private:
    enum
    {
        TEXT_MAX_LEN = 1024
    };

private:
    bool m_IsInitialized;
    CvFont m_Font;
    CvSize m_FontSize;
    CvScalar m_FontColor;
    char m_Text[TEXT_MAX_LEN];
}; //class TextWriter

//============================================================

} //namespace test

