﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "test_Common.h"
#include "test_TaskBase.h"

namespace test {

//============================================================
/**
 *  @brief タスク生成を行なう関数です。
 *         TaskFactoryContainer に渡すために定義しています。
 */
template< class T > TaskBase* TaskFactoryFunc(const char* name, uptr arg)
{
    test::TaskBase* p = new T(name, arg);
    return p;
} //TaskFactoryFunc()

//============================================================
/**
 *  @brief TaskFactoryFunc の関数ポインタの型宣言です。
 */
typedef test::TaskBase* (*TaskFactoryFuncPointer)(const char* name, uptr arg);

//============================================================
/**
 *  @brief TaskFactoryFunc を保持するためのオブジェクトです。
 *         さまざまなタスクの TaskFactoryFunc を保持することを想定しています。
 */
struct TaskFactoryContainer
{
    TaskFactoryFuncPointer   func;
    const char*              name;
    uptr                     arg;
}; //struct TaskFactoryContainer

} //namespace test
