﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Perf.h"

namespace test {

//============================================================
void Perf::Initialize(const s32 sectionNum)
{
    TEST_ASSERT(!m_IsInitialized);
    TEST_ASSERT(sectionNum > 0);

    m_aPerfUnit = new PerfUnit[sectionNum];
    TEST_ASSERT(m_aPerfUnit != NULL);
    m_SectionNum = sectionNum;
    m_IsInitialized = true;

    Clear();
} //Perf::Initialize()

//============================================================
void Perf::Finalize()
{
    if (m_IsInitialized)
    {
        delete[] m_aPerfUnit;
        m_SectionNum = 0;
        m_IsInitialized = false;
    }
} //Perf::Finalize()

//============================================================
void Perf::Print() const
{
    TEST_ASSERT(m_IsInitialized);
    for (s32 i = 0; i < m_SectionNum; i++)
    {
        TEST_PRINTF("section %d: latest=%lld usec, avg=%lld usec, count=%d\n", i, GetLatestSpan(i).GetMicroSeconds(), GetAverageSpanUsec(i), GetMeasureCount(i));
    }
} //Perf::Print()

//============================================================

} //namespace test
