﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_ConsoleMenu.h"
#include "test_CvUtil.h"
#include "test_ConsoleFrameworkOpenCv.h"

namespace test {

namespace {
    const CvSize WINDOW_SIZE = cvSize(320, 240);
    const CvSize FONT_SIZE = cvSize(16, 16);
    const char* WINDOW_NAME = "test : ConsoleMenu";
} //namespace

//============================================================
void ConsoleMenu::DoInitialize()
{
    TEST_ASSERT(m_CreateConfig.firstIndex < m_CreateConfig.taskNum);

    cvNamedWindow(WINDOW_NAME);
    m_pWindowImage = cvCreateImage(cvSize(WINDOW_SIZE.width, WINDOW_SIZE.height), IPL_DEPTH_8U, 3);
    TEST_ASSERT(m_pWindowImage != NULL);
    m_TextWriter.Initialize(FONT_SIZE);

    m_Cursor = m_CreateConfig.firstIndex;

    test::TaskFactoryContainer& factory = m_CreateConfig.pTaskFactoryTable[m_Cursor];
    m_pCurrentTask = factory.func(factory.name, factory.arg);
    TEST_ASSERT(m_pCurrentTask != NULL);
    m_pCurrentTask->Initialize(GetFramework());
    TEST_PRINTF("test : ConsoleMenu : start task %d : %s\n", m_Cursor, m_pCurrentTask->GetName());
} //ConsoleMenu::DoInitialize()

//============================================================
void ConsoleMenu::DoFinalize()
{
    if (m_pCurrentTask != NULL)
    {
        TEST_PRINTF("test : ConsoleMenu : end task %d : %s\n", m_Cursor, m_pCurrentTask->GetName());
        m_pCurrentTask->Finalize();
        delete m_pCurrentTask;
        m_pCurrentTask = NULL;
        m_TextWriter.Finalize();
        cvReleaseImage(&m_pWindowImage);
        cvDestroyWindow(WINDOW_NAME);
    }
} //ConsoleMenu::DoFinalize()

//============================================================
void ConsoleMenu::DoCalc()
{
    m_pCurrentTask->Calc();

    ConsoleFrameworkOpenCv* pFramework = dynamic_cast<ConsoleFrameworkOpenCv*>(TaskBase::GetFramework());
    if (pFramework != NULL)
    {
        s32 keycode = pFramework->GetKeycode();
        if (keycode == 'r')  // ReadyMode
        {
            DoChangeMode(0);
        }
        else if (keycode == 'm') // MomentMode
        {
            // Ready からのみ遷移許可
            if (m_Cursor == 0)
            {
                DoChangeMode(1);
            }
        }
        else if (keycode == 'c') // Clsutering
        {
            // Ready からのみ遷移許可
            if (m_Cursor == 0)
            {
                DoChangeMode(2);
            }
        }
        else if (keycode == 'i') // ImageTransfer
        {
            // Ready からのみ遷移許可
            if (m_Cursor == 0)
            {
                DoChangeMode(3);
            }
        }
        else if (keycode == 'd') // Dpd
        {
            // Ready からのみ遷移許可
            if (m_Cursor == 0)
            {
                DoChangeMode(4);
            }
        }
        else if (keycode == 'h') // Dpd
        {
            // Ready からのみ遷移許可
            if (m_Cursor == 0)
            {
                DoChangeMode(5);
            }
        }
    }
} //ConsoleMenu::DoCalc()

void ConsoleMenu::DoChangeMode(int mode)
{
    TEST_PRINTF("test : ConsoleMenu : end task %d : %s\n", m_Cursor, m_pCurrentTask->GetName());
    m_pCurrentTask->Finalize();
    delete m_pCurrentTask;
    m_pCurrentTask = NULL;
    m_Cursor = mode;
    test::TaskFactoryContainer& factory = m_CreateConfig.pTaskFactoryTable[m_Cursor];
    m_pCurrentTask = factory.func(factory.name, factory.arg);
    TEST_ASSERT(m_pCurrentTask != NULL);
    m_pCurrentTask->Initialize(GetFramework());
    m_pCurrentTask->Calc();  // ここで Calc をしておかないと Draw と Calc の順番がおかしくなる
    TEST_PRINTF("ConsoleMenu : start task %d : %s\n", m_Cursor, m_pCurrentTask->GetName());

}

//============================================================
void ConsoleMenu::DoDraw()
{
    m_pCurrentTask->Draw();

    cvSet(m_pWindowImage, CONST_COLOR_BLACK);
    for (s32 i = 0; i < m_CreateConfig.taskNum; i++)
    {
        if (m_Cursor == i)
        {
            m_TextWriter.SetFontColor(CONST_COLOR_RED);
            m_TextWriter.PutText(m_pWindowImage, 0, FONT_SIZE.height * i, "> %s", m_CreateConfig.pTaskFactoryTable[i].name);
        }
        else
        {
            m_TextWriter.SetFontColor(CONST_COLOR_WHITE);
            m_TextWriter.PutText(m_pWindowImage, 0, FONT_SIZE.height * i, "  %s", m_CreateConfig.pTaskFactoryTable[i].name);
        }
    }
    m_TextWriter.SetFontColor(CONST_COLOR_RED);
    int index = 8;
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press R to ReadyMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press I to ImageTransferMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press C to ClusteringMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press M to MomentMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press D to DpdMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press H to HandAnalysisMode");
    m_TextWriter.PutText(m_pWindowImage, 0, WINDOW_SIZE.height - FONT_SIZE.height * index--, "Press ESC to close Application");
    cvShowImage(WINDOW_NAME, m_pWindowImage);
} //ConsoleMenu::DoDraw()

//============================================================

} //namespace test
