﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Tick.h>
#include <nn/nn_TimeSpan.h>

#include <nn/xcd/xcd.h>
#include <nnt/nntest.h>

namespace {
    nn::os::MultiWaitType g_MultiWait;
} // namespace


/**
 * XCD ペアリングが成功することをテストする
 * リブート直後の状態でテストを行う必要がある
 */
TEST( XcdPairing, Basic )
{
    nn::os::InitializeMultiWait(&g_MultiWait);

    // XCDの初期化
    nn::xcd::Initialize(&g_MultiWait);
    nn::xcd::StartButtonPairing();

    while(1)
    {
        // デバイス情報の更新を待機
        auto pHolder = nn::os::WaitAny(&g_MultiWait);

        if(nn::xcd::Proceed(pHolder) == true)
        {
            // 何もしない
        }
    }
}
