﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd.h>

#include "testXcd_NfcAutoCommon.h"
#include "testXcd_NfcAutoFixture.h"

// Release ビルド時は ASSERT が消えるため、Death テストは実施しない
#if !defined(NN_SDK_BUILD_RELEASE)

// XCD (Hid) では Death テストが正常に走らない？ようなので、一旦止めておく
//#define NNT_XCD_ENABLE_DEATH_TEST

#endif

namespace nnt { namespace xcd {

// ステート遷移テストの試行回数
const int StateTransitionTestCount = 5;

// タグ検出テストのパラメータ
const nn::xcd::NfcDiscoveryParameter DiscoveryParameterList[] =
{
    // ポーリング対象タグ, タイムアウト [msec], ポーリング間隔 [msec]
    { nn::xcd::NfcPollingMask_TechnologyA, 3000, 300 },
    { nn::xcd::NfcPollingMask_All,         5000, 300 }
};

// タグ読み取りテストのパラメータ
// 固定パラメータでテストする場合に使用
const struct ReadTestParameter
{
    int32_t blockCount;
    nn::xcd::NtagReadAddress addresses[nn::xcd::NtagReadBlockCountMax];
} ReadParameterList[] =
{
    // ブロック数, { 開始アドレス1, 終了アドレス1, 開始アドレス2, ... }
    //  - ブロック数は 4 まで。アドレスの組はブロック数と同じ数
    { 1, { { 0x00, 0x3B } } },  // 1 ブロックの限界値
    { 2, { { 0x00, 0x39 }, { 0x3A, 0x73 } } },
    { 3, { { 0x00, 0x39 }, { 0x3A, 0x73 }, { 0x74, 0x86 } } },  // amiibo と同じ
    { 4, { { 0x00, 0x19 }, { 0x20, 0x39 }, { 0x3A, 0x73 }, { 0x74, 0x86 } } },
};

// アドレス、ブロック数をランダムに決定する読み取りテストのパラメータ
const struct ReadRandomTestParameter
{
    int     testCount;
    int32_t blockCountMax;
} ReadRandomParameterList[] =
{
    // 試行回数, ブロック数上限 (1-4)
    { 30, 1 },
    { 30, nn::xcd::NtagReadBlockCountMax },
};

// タグ書き込みテストのパラメータ
// 固定パラメータでテストする場合に使用
const struct WriteTestParameter
{
    uint8_t startAddress;
    int     writePages;
    uint8_t blockPageMax;
} WriteParameterList[] =
{
    // 開始アドレス, 書き込むサイズ

    // Type2 最小
    { NtagWriteTopPageForBlank, 1, nn::xcd::NtagWriteBlockPageCountMax },

    // Type2 最大 (3 ブロック指定)
    { NtagWriteTopPageForBlank, NtagWritePageMaxForBlank, nn::xcd::NtagWriteBlockPageCountMax },

    // Type2 最大 (4 ブロック指定)
    { NtagWriteTopPageForBlank, NtagWritePageMaxForBlank, 32 },
};

// データ量をランダムに決定する書き込みテストのパラメータ
const struct WriteRandomTestParameter
{
    int    testCount;
    size_t writeDataBytes;
} WriteRandomParameterList[] =
{
    // 試行回数, 書き込むサイズ上限
    { 30, NtagWritePageMaxForBlank * nn::xcd::Type2TagPageSize },
};

}}  // nnt::xcd


// ---------------- 以下、テスト用のクラス定義 ----------------

/**
 * @brief   ステート遷移テスト用クラス
 */
class XcdNfcStateTransition : public ::testing::TestWithParam<int>
{
};

/**
 * @brief   タグ検出テスト用クラス
 */
class XcdNfcDetect :
    public XcdNfcBase,
    public ::testing::WithParamInterface<nn::xcd::NfcDiscoveryParameter>
{
};

/**
 * @brief   タグ読み取りテスト (固定値版) 用クラス
 */
class XcdNfcRead :
    public XcdNfcBase,
    public ::testing::WithParamInterface<nnt::xcd::ReadTestParameter>
{
};

/**
 * @brief   タグ読み取りテスト (ランダム版) 用クラス
 */
class XcdNfcReadRandom :
    public XcdNfcBase,
    public ::testing::WithParamInterface<nnt::xcd::ReadRandomTestParameter>
{
};

/**
 * @brief   タグ書き込みテスト (固定値版) 用クラス
 */
class XcdNfcWrite :
    public XcdNfcBase,
    public ::testing::WithParamInterface<nnt::xcd::WriteTestParameter>
{
};

/**
 * @brief   タグ書き込みテスト (ランダム版) 用クラス
 */
class XcdNfcWriteRandom :
    public XcdNfcBase,
    public ::testing::WithParamInterface<nnt::xcd::WriteRandomTestParameter>
{
};
