﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd.h>

namespace nnt { namespace xcd {

/**
 * @brief   テスト用の Npad 設定
 */
void SetupNpad() NN_NOEXCEPT;

/**
 * @brief   書き込み先にシステム領域が含まれているか判定
 *
 * @param[in]   writeData   書き込みパラメータ
 *
 * @retval  true    システム領域が含まれる
 * @retval  false   システム領域が含まれない
 */
bool ContainsSystemArea(const nn::xcd::NtagWriteData& writeData) NN_NOEXCEPT;

/**
 * @brief   書き込み用の乱数データを生成
 *
 * @param[out]  pOutParameter   書き込みパラメータ
 * @param[in]   writePages      書き込むページ数
 * @param[in]   blockPageMax    ブロック毎のページ数上限
 *
 * @pre
 *   - @a pOutParameter != nullptr
 */
void CreateRandomWriteData(
    nn::xcd::NtagWriteParameter* pOutParameter,
    int writePages,
    uint8_t blockPageMax) NN_NOEXCEPT;

/**
 * @brief   Result の内容を表示
 *
 * @param[in]   result      対象の nn::Result
 */
void PrintResult(nn::Result result) NN_NOEXCEPT;

}}  // nnt::xcd
