﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/xcd/xcd_NfcTypes.h>

namespace nnt { namespace xcd {

// NFC デバイスの検知間隔
const auto DevicePollInterval = nn::TimeSpan::FromMilliSeconds(15);

// NFC デバイスの接続タイムアウト
const auto DeviceAttachTimeout = nn::TimeSpan::FromSeconds(30);

// ステート遷移タイムアウト
const auto StateTransitionTimeout = nn::TimeSpan::FromSeconds(10);

// タグアクセスのリトライ回数
const int RetryCount = 3;

// リトライ時のウェイト
const auto RetryWait = nn::TimeSpan::FromMilliSeconds(500);

// アクティベーション情報のページ番号
const uint8_t NtagActivationDataPage = 0x04;

// タグから読み込めるページ番号上限
const uint8_t NtagReadPageMax = 0x86;

// タグから読み込めるページ数上限
const uint8_t NtagReadPageCountMax = 0x87;

// 書き込みできるアドレスの先頭 (ブランクタグ用)
const uint8_t NtagWriteTopPageForBlank = 0x04;

// タグに対して書き込みできるページ数上限 (ブランクタグ用)
const uint8_t NtagWritePageMaxForBlank = 0x7E;

// アクティベーション情報のクリア値
extern const nn::Bit8 NtagActivationClearData[nn::xcd::NtagActivationAreaSize];

// アクティベーション情報
extern const nn::Bit8 NtagActivationData[nn::xcd::NtagActivationAreaSize];

}}  // nnt::xcd
