﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <nn/os.h>

#include "TA_uicontrol.h"

namespace TestAgent {

enum ProgramId {
    PROGRAM_ID_DEFAULT = 0,
    PROGRAM_ID_APPLICATION,
    PROGRAM_ID_LOCAL_MASTER,
    PROGRAM_ID_LOCAL_CLIENT,
    PROGRAM_ID_LOCAL_AUDIENCE,
    PROGRAM_ID_LOCAL_SCANNER,
    PROGRAM_ID_LOCAL_MEASURER,
    PROGRAM_ID_INFRA_CLIENT,
    PROGRAM_ID_LOG_SETTING,

    PROGRAM_ID_LOCAL_TEST,
    PROGRAM_ID_INFRA_TEST,

    PROGRAM_ID_H1_TEST,
    PROGRAM_ID_H2_TEST,
    PROGRAM_ID_H3_TEST,
    PROGRAM_ID_H4_TEST,
    PROGRAM_ID_H5_TEST,
    PROGRAM_ID_H6_TEST,
};

class Program {
protected:
    ProgramId m_ProgramId;
public:
    Program() {
        m_ProgramId = PROGRAM_ID_DEFAULT;
    }
    virtual ~Program() {
    }
    virtual void Execute() {
    }
    virtual void Exit() {
    }
    virtual ProgramId GetProgramId() const {
        return m_ProgramId;
    }
};

class Application: public Program {
private:
    bool m_NeedExit;

protected:
    virtual void ApplicationImpl() {
    }
    virtual void Initialize() {
    }
    virtual void Finalize() {
    }

public:
    Application() {
        m_NeedExit = false;
    }

    virtual ~Application() {
        Exit();
    }

    virtual void Execute() {
        Initialize();

        m_NeedExit = false;
        Pad &pad = Pad::GetInstance();
        while (!m_NeedExit) {
            pad.UpdatePadState();
            //stats.Update();
            ApplicationImpl();
            nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10)); // 少しウェイトを入れる
            Display::GetInstance().SwapBuffer();
        }

        Finalize();
    }

    virtual void Exit() {
        m_NeedExit = true;
    }
};
}
