﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <string>

namespace TestAgent {

using namespace std;

const float DEFAULT_FIXED_WIDTH        = 20;
const float DEFAULT_FONT_WIDTH         = 24;
const float DEFAULT_FONT_HEIGHT        = 30;

const uint32_t REMOTE_COUNT_MAX = 1;

enum Button
{
    START = 0,
    SELECT,
    A,
    B,
    X,
    Y,
    L,
    R,
    ZL,
    ZR,
    LEFT,
    UP,
    RIGHT,
    DOWN,
    SL,       // stick left emulation
    SL_LEFT,
    SL_UP,
    SL_RIGHT,
    SL_DOWN,
    SR,      // stick right emulation
    SR_LEFT,
    SR_UP,
    SR_RIGHT,
    SR_DOWN,
    MINUS,
    PLUS
};

void ToUpper(char* str, int size);

string ToStringSimpleTimeSpan(const nn::TimeSpan& timespan);
}
