@ECHO OFF

CALL %~dp0\SetDefineIni.bat
CALL %~dp0\SetDefineJoycon.bat

SETLOCAL ENABLEDELAYEDEXPANSION

SET JOY_CMD=%WLANTEST_SDKROOT%\Integrate\Scripts\NX\GamePad\ControlExtCon.exe
SET USB_CMD=%WLANTEST_SDKROOT%\Tests\Outputs\x64-v140\Tests\UsbListup\Release\UsbListup.exe
SET JOY_CNT=0
SET JOY_PAIRING_STATE=0
SET JOY_UNPAIRING_STATE=0

SET JOY_CNT_SEACH=-jcnt:
SET JOY_PAIRING_SEACH=-p
SET JOY_UNPAIRING_SEACH=-up
SET COMP_INFO=FTDI

IF NOT DEFINED WLANTEST_JOYAUTO (
	EXIT /b 0
)

:PRMLOOP

IF NOT "%~1" == "" (

  ECHO %1 | find "%JOY_CNT_SEACH%" > NUL
  IF not ERRORLEVEL 1 (
    SET JOY_CNT=%1
    SET JOY_CNT=!JOY_CNT:%JOY_CNT_SEACH%=!
  )

  ECHO %1 | find "%JOY_PAIRING_SEACH%" > NUL
  IF not ERRORLEVEL 1 (
    SET JOY_PAIRING_STATE=1
  )

  ECHO %1 | find "%JOY_UNPAIRING_SEACH%" > NUL
  IF not ERRORLEVEL 1 (
    SET JOY_UNPAIRING_STATE=1
  )

  SHIFT
  goto PRMLOOP
)


IF NOT EXIST %JOY_CMD% (
	ECHO ControlExtCon Not exist
	GOTO ERROR_MSG
)

IF NOT EXIST %USB_CMD% (
	ECHO u%USB_CMD%vin the serial port setting can not be found
	GOTO ERROR_MSG
)

IF %JOY_CNT% EQU 0 (
	ECHO Argument Err
	GOTO ERROR_MSG
)

IF %JOY_SET_CNT% LSS %JOY_CNT% (
	ECHO Less than specified number of ini files
	ECHO File setting number:%JOY_SET_CNT%^%JOY_CNT%
	GOTO ERROR_MSG
)

IF %JOY_CNNECT_CNT% LSS %JOY_CNT% (
	ECHO The number of JoyCon connected to the serial port is less than the set number.
	ECHO Connection serial port Count:%JOY_CNNECT_CNT%^%JOY_CNT%
	GOTO ERROR_MSG
)

FOR /l %%c in (1, 1, %JOY_CNT%) do (
    SET SET_PORT=
    FOR /l %%a in (1, 1, %JOY_CNNECT_CNT%) do (
        IF "!JOY_COM_NO%%a_MAC!" == "!JOY_NO%%c!" (
            SET SET_PORT=!JOY_COM_NO%%a_PORT!
        )
    )

    IF "!SET_PORT!" == "" (
    	ECHO JoyCon set in the INI file is not connected.
        ECHO !JOY_NO%%c_NAME!i!JOY_NO%%c!j
    	GOTO ERROR_MSG
    )

	IF %JOY_PAIRING_STATE% EQU 1 (
        ECHO JoyCon Pairing F!JOY_NO%%c_NAME!i!JOY_NO%%c!j
		SET SET_CMD=%JOY_CMD% --port !SET_PORT! reset-page
	) ELSE IF %JOY_UNPAIRING_STATE% EQU 1 (
        ECHO JoyCon UnpairedF!JOY_NO%%c_NAME!i!JOY_NO%%c!j
		SET SET_CMD=%JOY_CMD% --port !SET_PORT! reset-pair
	) ELSE (
		ECHO Argument Err
        ECHO !JOY_NO%%c_NAME!i!JOY_NO%%c!j
		GOTO ERROR_MSG
	)

	FOR /f "usebackq delims=" %%a in (`cmd /c !SET_CMD!`) do (
		ECHO %%a | find "Failed" > NUL
		IF not ERRORLEVEL 1 (
			ECHO Failed to execute the next command.
			ECHO Please check whether JoyCon is connected to Writer and try again.
			ECHO;
			ECHO cmd /c !SET_CMD!
			GOTO ERROR_MSG
		)
	)
)


GOTO EXIT_JOY

:ERROR_MSG

PAUSE
EXIT /b 1

:EXIT_JOY


EXIT /b 0

