﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pcv/pcv.h>

//#include <common_vcc.h>

// SIGLO-72129: VCC ライブラリ側の VCC_DEBUG_PRINT_TREE の値の定義は common_vcc.h 内にあります。
//              予告なく定義内容が変わる可能性がありますので本テストを使用される際は事前に common_vcc.h 内の定義をご確認ください。
//              以前は直接 include していましたが、別のヘッダへの依存が発生したため中止しました。

#define VCC_DEBUG_PRINT_TREE            0x54524545 // NOLINT(preprocessor/const)

// PCV 経由ですが PCV の機能ではなく VCC の特有の機能を使用する意図で VCC 以下のツールとしました。
// Firmware Debug Settings を以下の設定にしなければ動作しません。
/*
            "vcc_debug_ip": {
                "current": "1",
                "default": ""
            },
*/

extern "C" void nnMain()
{
    nn::pcv::Initialize();

    nn::pcv::SetClockRate(nn::pcv::Module_Owr, VCC_DEBUG_PRINT_TREE);

    nn::pcv::Finalize();
}
