﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/utilTool/utilTool_ConverterUtil.h>

namespace {

TEST( ConverterUtilParseTest, ConverterUtil )
{
    char charNumber;
    nn::utilTool::ConverterUtil::Parse( &charNumber, "0" );
    EXPECT_EQ( 0, charNumber );

    nn::utilTool::ConverterUtil::Parse( &charNumber, "10" );
    EXPECT_EQ( 16, charNumber );

    nn::utilTool::ConverterUtil::Parse( &charNumber, " 1A " );
    EXPECT_EQ( 26, charNumber );

    nn::utilTool::ConverterUtil::Parse( &charNumber, "NOT_CHAR" );
    EXPECT_EQ( 0, charNumber );

    int intNumber;
    nn::utilTool::ConverterUtil::Parse( &intNumber, "0" );
    EXPECT_EQ( 0, intNumber );

    nn::utilTool::ConverterUtil::Parse( &intNumber, "10" );
    EXPECT_EQ( 10, intNumber );

    nn::utilTool::ConverterUtil::Parse( &intNumber, " 11 " );
    EXPECT_EQ( 11, intNumber );

    nn::utilTool::ConverterUtil::Parse( &intNumber, "NOT_INTEGER" );
    EXPECT_EQ( 0, intNumber );

    float floatNumber;
    nn::utilTool::ConverterUtil::Parse( &floatNumber, "0" );
    EXPECT_EQ( 0, floatNumber );

    nn::utilTool::ConverterUtil::Parse( &floatNumber, " 10.0 " );
    EXPECT_EQ( 10, floatNumber );

    nn::utilTool::ConverterUtil::Parse( &floatNumber, "10.1" );
    EXPECT_EQ( 10.1f, floatNumber );

    nn::utilTool::ConverterUtil::Parse( &floatNumber, "NOT_FLOAT" );
    EXPECT_EQ( 0, floatNumber );

    bool boolean;
    nn::utilTool::ConverterUtil::Parse( &boolean, "TRUE" );
    EXPECT_TRUE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, "true" );
    EXPECT_TRUE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, " true " );
    EXPECT_TRUE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, "NOT_BOOL" );
    EXPECT_TRUE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, "FALSE" );
    EXPECT_FALSE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, "false" );
    EXPECT_FALSE( boolean );

    nn::utilTool::ConverterUtil::Parse( &boolean, " false " );
    EXPECT_FALSE( boolean );
}

} // anonymous namespace
