﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/detail/util_VectorApi.general.h>

namespace nn {
namespace util {
namespace general {

Vector2fType MakeVector2fTypeWrapper(float x, float y);
void VectorLoadWrapper(Vector2fType* pOutValue, const float* pSource);
void VectorLoadWrapper(Vector2fType* pOutValue, const Float2& source);
void VectorStoreWrapper(float* pOutValue, const Vector2fType& source);
void VectorStoreWrapper(Float2* pOutValue, const Vector2fType& source);
void VectorSetWrapper(Vector2fType* pOutValue, float x, float y);
void VectorSetXWrapper(Vector2fType* pOutValue, float value);
void VectorSetYWrapper(Vector2fType* pOutValue, float value);
float VectorGetXWrapper(const Vector2fType& vector);
float VectorGetYWrapper(const Vector2fType& vector);
void VectorZeroWrapper(Vector2fType* pOutValue);
bool VectorIsZeroWrapper(const Vector2fType& vector);
bool VectorIsZeroWrapper(const Vector2fType& vector, float error);
void VectorAddWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
void VectorSubtractWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
void VectorMultiplyWrapper(Vector2fType* pOutValue, const Vector2fType& vector, float factor);
void VectorMultiplyWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
void VectorDivideWrapper(Vector2fType* pOutValue, const Vector2fType& vector, float factor);
void VectorDivideWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
float VectorDotWrapper(const Vector2fType& vector1, const Vector2fType& vector2);
float VectorCrossWrapper(const Vector2fType& vector1, const Vector2fType& vector2);
float VectorLengthWrapper(const Vector2fType& vector);
float VectorLengthSquaredWrapper(const Vector2fType& vector);
float VectorDistanceWrapper(const Vector2fType& vector1, const Vector2fType& vector2);
float VectorDistanceSquaredWrapper(const Vector2fType& vector1, const Vector2fType& vector2);
float VectorNormalizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector);
void VectorMaximizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
void VectorMinimizeWrapper(Vector2fType* pOutValue, const Vector2fType& vector1, const Vector2fType& vector2);
void VectorLerpWrapper(Vector2fType* pOutValue, const Vector2fType& from, const Vector2fType& to, float t);
void VectorTransformWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixRowMajor3x2fType& matrix);
void VectorTransformWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixColumnMajor3x2fType& matrix);
void VectorTransformNormalWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixRowMajor3x2fType& matrix);
void VectorTransformNormalWrapper(Vector2fType* pOutValue, const Vector2fType& vector, const MatrixColumnMajor3x2fType& matrix);
Vector3fType MakeVector3fTypeWrapper(float x, float y, float z);
void VectorLoadWrapper(Vector3fType* pOutValue, const float* pSource);
void VectorLoadWrapper(Vector3fType* pOutValue, const Float3& source);
void VectorStoreWrapper(float* pOutValue, const Vector3fType& source);
void VectorStoreWrapper(Float3* pOutValue, const Vector3fType& source);
void VectorSetWrapper(Vector3fType* pOutValue, float x, float y, float z);
void VectorSetXWrapper(Vector3fType* pOutValue, float value);
void VectorSetYWrapper(Vector3fType* pOutValue, float value);
void VectorSetZWrapper(Vector3fType* pOutValue, float value);
float VectorGetXWrapper(const Vector3fType& vector);
float VectorGetYWrapper(const Vector3fType& vector);
float VectorGetZWrapper(const Vector3fType& vector);
void VectorZeroWrapper(Vector3fType* pOutValue);
bool VectorIsZeroWrapper(const Vector3fType& vector);
bool VectorIsZeroWrapper(const Vector3fType& vector, float error);
void VectorAddWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
void VectorSubtractWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
void VectorMultiplyWrapper(Vector3fType* pOutValue, const Vector3fType& vector, float factor);
void VectorMultiplyWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
void VectorDivideWrapper(Vector3fType* pOutValue, const Vector3fType& vector, float factor);
void VectorDivideWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
float VectorDotWrapper(const Vector3fType& vector1, const Vector3fType& vector2);
void VectorCrossWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
float VectorLengthWrapper(const Vector3fType& vector);
float VectorLengthSquaredWrapper(const Vector3fType& vector);
float VectorDistanceWrapper(const Vector3fType& vector1, const Vector3fType& vector2);
float VectorDistanceSquaredWrapper(const Vector3fType& vector1, const Vector3fType& vector2);
float VectorNormalizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector);
void VectorMaximizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
void VectorMinimizeWrapper(Vector3fType* pOutValue, const Vector3fType& vector1, const Vector3fType& vector2);
void VectorLerpWrapper(Vector3fType* pOutValue, const Vector3fType& from, const Vector3fType& to, float t);
void VectorRotateWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const Vector4fType& quaternion);
void VectorTransformWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x3fType& matrix);
void VectorTransformWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x3fType& matrix);
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x4fType& matrix);
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x4fType& matrix);
void VectorTransformNormalWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x3fType& matrix);
void VectorTransformNormalWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x3fType& matrix);
void VectorTransformCoordWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixRowMajor4x4fType& matrix);
void VectorTransformCoordWrapper(Vector3fType* pOutValue, const Vector3fType& vector, const MatrixColumnMajor4x4fType& matrix);
Vector4fType MakeVector4fTypeWrapper(float x, float y, float z, float w);
void VectorLoadWrapper(Vector4fType* pOutValue, const Uint8x4& source);
void VectorLoadWrapper(Vector4fType* pOutValue, const Unorm8x4& source);
void VectorLoadWrapper(Vector4fType* pOutValue, const float* pSource);
void VectorLoadWrapper(Vector4fType* pOutValue, const Float4& source);
void VectorStoreWrapper(Uint8x4* pOutValue, const Vector4fType& source);
void VectorStoreWrapper(Unorm8x4* pOutValue, const Vector4fType& source);
void VectorStoreWrapper(float* pOutValue, const Vector4fType& source);
void VectorStoreWrapper(Float4* pOutValue, const Vector4fType& source);
void VectorSetWrapper(Vector4fType* pOutValue, float x, float y, float z, float w);
void VectorSetXWrapper(Vector4fType* pOutValue, float value);
void VectorSetYWrapper(Vector4fType* pOutValue, float value);
void VectorSetZWrapper(Vector4fType* pOutValue, float value);
void VectorSetWWrapper(Vector4fType* pOutValue, float value);
float VectorGetXWrapper(const Vector4fType& vector);
float VectorGetYWrapper(const Vector4fType& vector);
float VectorGetZWrapper(const Vector4fType& vector);
float VectorGetWWrapper(const Vector4fType& vector);
void VectorZeroWrapper(Vector4fType* pOutValue);
bool VectorIsZeroWrapper(const Vector4fType& vector);
bool VectorIsZeroWOneWrapper(const Vector4fType& vector);
void VectorAddWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
void VectorSubtractWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
void VectorMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& vector, float factor);
void VectorMultiplyWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
void VectorDivideWrapper(Vector4fType* pOutValue, const Vector4fType& vector, float factor);
void VectorDivideWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
float VectorDotWrapper(const Vector4fType& vector1, const Vector4fType& vector2);
float VectorLengthWrapper(const Vector4fType& vector);
float VectorLengthSquaredWrapper(const Vector4fType& vector);
float VectorDistanceWrapper(const Vector4fType& vector1, const Vector4fType& vector2);
float VectorDistanceSquaredWrapper(const Vector4fType& vector1, const Vector4fType& vector2);
float VectorNormalizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector);
void VectorMaximizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
void VectorMinimizeWrapper(Vector4fType* pOutValue, const Vector4fType& vector1, const Vector4fType& vector2);
void VectorLerpWrapper(Vector4fType* pOutValue, const Vector4fType& from, const Vector4fType& to, float t);
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector4fType& vector, const MatrixRowMajor4x4fType& matrix);
void VectorTransformWrapper(Vector4fType* pOutValue, const Vector4fType& vector, const MatrixColumnMajor4x4fType& matrix);

}
}
}
