﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/util/util_ScopeExit.h>

#include <utility>

TEST(testUtil_ScopeExit, Basic)
{
    auto n = 10;
    {
        NN_UTIL_SCOPE_EXIT
        {
            n = 20;
        };
        ASSERT_EQ(10, n);
    }
    ASSERT_EQ(20, n);
}

TEST(testUtil_ScopeExit, Commit)
{
    {
        auto n = 10;
        auto commit = false;
        {
            NN_UTIL_SCOPE_EXIT
            {
                if (commit)
                {
                    n = 20;
                }
            };
            ASSERT_EQ(10, n);
        }
        ASSERT_EQ(10, n);
    }
    {
        auto n = 10;
        auto commit = false;
        {
            NN_UTIL_SCOPE_EXIT
            {
                if (commit)
                {
                    n = 20;
                }
            };
            ASSERT_EQ(10, n);
            commit = true;
        }
        ASSERT_EQ(20, n);
    }
}
