﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/nntest.h>
#include <nn/util/util_ResDic.h>

namespace nn { namespace util {

TEST( ResDicTest, ResDic )
{
    size_t poolSize = 16 * 13;
    void* pStringPool = malloc( poolSize );
    const char* months[] = {
        "", "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
    };

    size_t dicSize = sizeof( ResDicData ) + sizeof( ResDicData::Entry ) * 12;
    ResDicData* pDicData = static_cast< ResDicData* >( malloc( dicSize ) );
    memset( pDicData, 0, dicSize );
    pDicData->count = 12;

    BinString* pBinString = static_cast< BinString* >( pStringPool );
    for ( int monthIndex = 0; monthIndex < 13; ++monthIndex )
    {
        pBinString->Initialize( months[ monthIndex ] );
        EXPECT_FALSE( pBinString == NULL );
        pDicData->entries[ monthIndex ].pKey.Set( pBinString );
        pBinString = pBinString->GetNext();
    }

    ResDic* pDic = static_cast< ResDic* >( static_cast< void* >( pDicData ) );
    bool result = pDic->Build();
    EXPECT_TRUE( result );
    NN_UNUSED( result );

    EXPECT_EQ( ResDic::Npos, pDic->FindIndex( "Month" ) );
    EXPECT_EQ( 0, pDic->FindIndex( "January" ) );
    EXPECT_EQ( 1, pDic->FindIndex( "February" ) );
    EXPECT_EQ( 2, pDic->FindIndex( "March" ) );
    EXPECT_EQ( 3, pDic->FindIndex( "April" ) );
    EXPECT_EQ( 4, pDic->FindIndex( "May" ) );
    EXPECT_EQ( 5, pDic->FindIndex( "June" ) );
    EXPECT_EQ( 6, pDic->FindIndex( "July" ) );
    EXPECT_EQ( 7, pDic->FindIndex( "August" ) );
    EXPECT_EQ( 8, pDic->FindIndex( "September" ) );
    EXPECT_EQ( 9, pDic->FindIndex( "October" ) );
    EXPECT_EQ( 10, pDic->FindIndex( "November" ) );
    EXPECT_EQ( 11, pDic->FindIndex( "December" ) );

    free( pDicData );
    free( pStringPool );
}

}} // namespace nn::util
