﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nnt/nntest.h>

#include <nn/util/util_VectorApi.h>
#include <nn/util/util_MatrixApi.h>
#include <nn/util/util_Arithmetic.h>

#define NNT_UTIL_COLOR4U8_EXPECT_EQ(color_, x_, y_, z_, w_) \
    do{ \
        EXPECT_EQ(x_, color_.v[0]); \
        EXPECT_EQ(y_, color_.v[1]); \
        EXPECT_EQ(z_, color_.v[2]); \
        EXPECT_EQ(w_, color_.v[3]); \
    }while(0)

#define NNT_UTIL_COLOR4F_EXPECT_EQ(color_, x_, y_, z_, w_) \
    do{ \
        nn::util::Float4 f_; \
        nn::util::VectorStore(&f_, color_); \
        EXPECT_EQ(x_, f_.v[0]); \
        EXPECT_EQ(y_, f_.v[1]); \
        EXPECT_EQ(z_, f_.v[2]); \
        EXPECT_EQ(w_, f_.v[3]); \
    }while(0)

#define NNT_UTIL_COLOR4F_EXPECT_NEARLY_EQ(vector_, x_, y_, z_, w_, error_) \
    do{ \
        nn::util::Float4 f_; \
        nn::util::VectorStore(&f_, vector_); \
        EXPECT_PRED3(nn::util::AreEqual, x_, f_.v[0], error_); \
        EXPECT_PRED3(nn::util::AreEqual, y_, f_.v[1], error_); \
        EXPECT_PRED3(nn::util::AreEqual, z_, f_.v[2], error_); \
        EXPECT_PRED3(nn::util::AreEqual, w_, f_.v[3], error_); \
    }while(0)
