﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include "RadioGroup.h"
#include "Scene.h"

namespace nnt {
namespace usb {

class SceneSelector : public RadioGroup
{
public:
    explicit SceneSelector(const glv::Rect& rect);

    virtual const char *className() const NN_OVERRIDE { return "SceneSelector"; };
    SceneSelector& Add(Scene& scene);

private:
    virtual void OnChange(int value) NN_OVERRIDE;

private:
    std::vector<Scene*>   m_Scenes;
};


} // ~usb
} // ~nnt
