﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stack>

#include <glv.h>
#include <glv_viewcontainer.h>

#include "Stage.h"

namespace nnt {
namespace usb {

class Scene : public glv::ViewContainer
{
    NN_DISALLOW_COPY( Scene );
    NN_DISALLOW_MOVE( Scene );

public:
    Scene(Stage& stage, const char *name) NN_NOEXCEPT;

    virtual const char *className() const NN_OVERRIDE { return "Scene"; };
    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_OVERRIDE;

    void Enter() NN_NOEXCEPT;
    void Exit() NN_NOEXCEPT;
    void Replace() NN_NOEXCEPT;

    const char *GetName() NN_NOEXCEPT
    {
        return m_Name;
    }

    static Scene* GetCurrent() NN_NOEXCEPT
    {
        return m_Stack.size() ? m_Stack.top() : nullptr;
    }

protected:
    virtual void OnEnter() NN_NOEXCEPT;
    virtual void OnExit() NN_NOEXCEPT;

private:
    Stage&      m_Stage;
    const char *m_Name;

    static std::stack<Scene*> m_Stack;
};

} // ~usb
} // ~nnt
