﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include "Button.h"

namespace nnt {
namespace usb {

class RadioButton;

class RadioGroup : public glv::Table
{
public:
    RadioGroup(const glv::Rect& rect, size_t nx);
    RadioGroup(std::initializer_list<std::string> captions, const glv::Rect& rect, size_t nx);
    ~RadioGroup();

    virtual const char *className() const NN_OVERRIDE { return "RadioGroup"; };

    RadioGroup& Add(const std::string& caption);
    void Select(RadioButton& button);
    glv::View* Select(int index);
    void UpdateFocus();

private:
    virtual void OnChange(int value);

public:
    Button::Style  onStyle;
    Button::Style  offStyle;

private:
    size_t             m_Count;
    const glv::Rect    m_Rect;
    RadioButton       *m_pActiveButton;
};

class RadioButton : public Button
{
public:
    RadioButton(const glv::Rect& rect, const std::string& caption, RadioGroup& group, int value);

    virtual void OnClicked() NN_OVERRIDE;
    virtual const char *className() const NN_OVERRIDE { return "RadioButton"; };

    int GetValue() const;

private:
    RadioGroup&   m_Group;
    const int     m_Value;
};

} // ~usb
} // ~nnt
