﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include <glv_viewcontainer.h>

#include "widgets/SceneSelector.h"

namespace nnt {
namespace usb {

class MenuView : public glv::View
{
    NN_DISALLOW_COPY( MenuView );
    NN_DISALLOW_MOVE( MenuView );

public:
    explicit MenuView(const glv::Rect& rect) NN_NOEXCEPT;

    ~MenuView() NN_NOEXCEPT;

    virtual const char *className() const { return "MenuView"; };

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT;
    virtual void onAnimate(double dsec) NN_NOEXCEPT;

    void AttachScene(Scene& scene) NN_NOEXCEPT;
    void Select(int index) NN_NOEXCEPT;

protected:
    virtual glv::View* firstFocusView() { return m_Selector.child; };

private:
    glv::space_t       m_Speed;

    SceneSelector      m_Selector;
    glv::ViewContainer m_Frame;

private:
    void AddEntry(glv::View *pView);
    static void Show(const glv::Notification& n);
    static void Hide(const glv::Notification& n);
};

} // ~usb
} // ~nnt
