﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "UsbDiag_Theme.h"
#include "UsbDiag_HeartBeatView.h"

namespace nnt {
namespace usb {

HeartBeatView::HeartBeatView(glv::space_t dim) NN_NOEXCEPT
    : glv::View(glv::Rect(dim, dim))
    , m_Frame(0)
    , m_Alpha(0)
{
    enable(glv::Property::Animate);
    disable(glv::Property::DrawBorder | glv::DrawBack | glv::HitTest);
}

HeartBeatView::~HeartBeatView() NN_NOEXCEPT
{
    // nothing special
}

void HeartBeatView::onDraw(glv::GLV& g) NN_NOEXCEPT
{
    glv::draw::color(0.1f, m_Alpha);
    glv::draw::rectangle(0, 0, width(), height());
}

void HeartBeatView::onAnimate(double dsec)
{
    if (m_Frame < 15)
    {
        m_Alpha = 1;
    }
    else if (m_Frame < 30)
    {
        m_Alpha = 0;
    }
    else if (m_Frame < 120)
    {
        m_Alpha = (120.0f - m_Frame) / 90.f;
    }

    if (++m_Frame >= 120)
    {
        m_Frame = 0;
    }
}

} // ~usb
} // ~nnt
