﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include <nn/usb/usb_Pm.h>
#include <nn/usb/pd/usb_PdCradle.h>

#include "UsbDiag_HeartBeatView.h"

namespace nnt {
namespace usb {

class FooterView : public glv::View
{
    NN_DISALLOW_COPY( FooterView );
    NN_DISALLOW_MOVE( FooterView );

public:
    FooterView(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~FooterView() NN_NOEXCEPT;

    virtual const char *className() const { return "FooterView"; };

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT;

private:
    glv::Label    m_UsbModeLabel;
    HeartBeatView m_HeartBeat;

    char                            m_Buffer[128];
    nn::usb::UsbPowerState          m_PowerState;
    nn::usb::UsbDataRole            m_DataRole;
    nn::usb::pd::VdmPdcHFwVersion   m_CradleVersion;

private:
    void UpdateLabel() NN_NOEXCEPT;
    static void OnPowerStateChange (const glv::Notification& n) NN_NOEXCEPT;
    static void OnDataRoleChange   (const glv::Notification& n) NN_NOEXCEPT;
    static void OnCradleStateChange(const glv::Notification& n) NN_NOEXCEPT;
};

} // ~usb
} // ~nnt
