﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "UsbDiag_UsbModel.h"

namespace nnt {
namespace usb {

class EpView : public glv::View
{
public:
    explicit EpView(const Endpoint& endpoint) NN_NOEXCEPT;

    ~EpView() NN_NOEXCEPT;

    virtual const char *className() const { return "EpView"; };

private:
    void CreateDetailView() NN_NOEXCEPT;

private:
    char              m_String[128];
    const Endpoint&   m_Endpoint;

    glv::Table        m_Detail;
};

} // ~usb
} // ~nnt
