﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

namespace nnt {
namespace usb {

class DetailView : public glv::Scroll
{
    NN_DISALLOW_COPY( DetailView );
    NN_DISALLOW_MOVE( DetailView );

public:
    DetailView(const unsigned width, const unsigned height) NN_NOEXCEPT;

    ~DetailView() NN_NOEXCEPT;

    virtual const char *className() const { return "DetailView"; };

private:
    static void OnUpdateDetail(const glv::Notification& n) NN_NOEXCEPT;
};

} // ~usb
} // ~nnt
