﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "UsbDiag_Theme.h"
#include "UsbDiag_AdaptiveListView.h"

namespace nnt {
namespace usb {

AdaptiveListView& AdaptiveListView::Adapt(bool vertical) NN_NOEXCEPT
{
    if (vertical)
    {
        return AdaptVertical();
    }
    else
    {
        return AdaptHorizontal();
    }
}

AdaptiveListView& AdaptiveListView::AdaptVertical() NN_NOEXCEPT
{
    glv::space_t totalHeight = 0;
    glv::space_t currentHeight = 0;
    glv::space_t maxWidth = 0;
    glv::View *cv = child;

    // stack the subviews and calculate the total height / maximum width
    while (cv)
    {
        cv->pos(glv::Place::TL, 0, totalHeight);

        if (cv->width() > maxWidth)
        {
            maxWidth = cv->width();
        }

        // be careful, reset anchor and stretch before extent
        cv->anchor(0, 0).stretch(0, 0);

        totalHeight += cv->height();
        cv = cv->sibling;
    }

    // set my rect to fit the subviews
    extent(maxWidth, totalHeight);

    // adjust subview width, anchor and stretch
    cv = child;
    while (cv)
    {
        cv->width(maxWidth);
        cv->anchor(0, currentHeight / totalHeight);
        cv->stretch(1, cv->height() / totalHeight);

        currentHeight += cv->height();
        cv = cv->sibling;
    }

    return *this;
}

AdaptiveListView& AdaptiveListView::AdaptHorizontal() NN_NOEXCEPT
{
    glv::space_t totalWidth = 0;
    glv::space_t currentWidth = 0;
    glv::space_t maxHeight = 0;
    glv::View *cv = child;

    // stack the subviews and calculate the total width / maximum height
    while (cv)
    {
        cv->pos(glv::Place::TL, totalWidth, 0);

        if (cv->height() > maxHeight)
        {
            maxHeight = cv->height();
        }

        // be careful, reset anchor and stretch before extent
        cv->anchor(0, 0).stretch(0, 0);

        totalWidth += cv->width();
        cv = cv->sibling;
    }

    // set my rect to fit the subviews
    extent(totalWidth, maxHeight);

    // adjust subview height, anchor and stretch
    cv = child;
    while (cv)
    {
        cv->height(maxHeight);
        cv->anchor(currentWidth / totalWidth, 0);
        cv->stretch(cv->width() / totalWidth, 1);

        currentWidth += cv->width();
        cv = cv->sibling;
    }

    return *this;
}

} // ~usb
} // ~nnt
