﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>
#include <nn/os.h>
#include <nn/audio.h>
#include <nn/mem.h>

namespace nns {
namespace iodevices {

class Microphone
{
public:
    static const int MinBufferLengthMilliseconds = 5;
    static const int MaxBufferLengthMilliseconds = 50;
    static const int NumBuffers = 2;
    using BufferCallback = std::function<void(void*, size_t)>;

public:
    Microphone();
    void Initialize(int bufferLengthMilliseconds, nn::mem::StandardAllocator* allocator) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    bool Open(nn::audio::AudioInInfo info) NN_NOEXCEPT;
    void Close() NN_NOEXCEPT;
    bool Start() NN_NOEXCEPT;
    void Stop() NN_NOEXCEPT;

    void Update(BufferCallback callback) NN_NOEXCEPT;

    bool IsOpen() NN_NOEXCEPT;
    bool IsStarted() NN_NOEXCEPT;

    nn::os::SystemEventType* GetBufferEvent() NN_NOEXCEPT;

    const char* GetName() NN_NOEXCEPT;

    const nn::audio::AudioInInfo& GetInfo() NN_NOEXCEPT;

private:
    nn::mem::StandardAllocator* m_Allocator;

    nn::os::SystemEvent m_BufferEvent;

    int m_BufferLengthMilliseconds;
    nn::audio::AudioInInfo m_AudioInInfo;
    nn::audio::AudioIn m_AudioIn;
    nn::audio::AudioInBuffer m_BufferInfo[NumBuffers];

    bool m_IsInitialized;
    bool m_IsStarted;
    bool m_IsOpen;
};

} // namespace iodevices
} // namepace nns
