﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Methods/Fx3.h"

namespace nnt {
namespace usb {
namespace hs {

const Fx3DeviceMode deviceModes[] =
{
    {FX3_DEVICE_FULL_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_HIGH_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_SUPER_SPEED, FX3_CTRL_MPS_512, FX3_INTERFACE_CTRL},
};

enum
{
    TRANSFER_BUFFER_SIZE        = 512,
};

static NN_ALIGNAS(4096) uint8_t g_Buffer[TRANSFER_BUFFER_SIZE];

static void PerformCtrlStallTest()
{
    Fx3TestDataRarameters fx3TestDataParameters;

    std::memset(&fx3TestDataParameters, 0, sizeof(Fx3TestDataRarameters));

    fx3TestDataParameters.entries                   = 1;
    fx3TestDataParameters.dataSeed                  = 0xffffeeee;
    fx3TestDataParameters.params[0].requestBytes    = TRANSFER_BUFFER_SIZE;

    fx3TestDataParameters.endpointAddress           = FX3_ENDPOINT_CTRL_0_IN;
    fx3TestDataParameters.params[0].transferBytes   = 0;
    Fx3TransferData(&fx3TestDataParameters, g_Buffer);

    //stall autoatically cleared for ctrl

    fx3TestDataParameters.params[0].transferBytes  = TRANSFER_BUFFER_SIZE;
    Fx3TransferData(&fx3TestDataParameters, g_Buffer);

    fx3TestDataParameters.endpointAddress           = FX3_ENDPOINT_CTRL_0_OUT;
    fx3TestDataParameters.params[0].transferBytes   = 0;
    Fx3TransferData(&fx3TestDataParameters, g_Buffer);

    //stall autoatically cleared for ctrl

    fx3TestDataParameters.params[0].transferBytes  = TRANSFER_BUFFER_SIZE;
    Fx3TransferData(&fx3TestDataParameters, g_Buffer);
}

class HsFx3CtrlStallTest : public ::testing::TestWithParam<Fx3DeviceMode>{};

INSTANTIATE_TEST_CASE_P(DeviceModes, HsFx3CtrlStallTest, ::testing::ValuesIn(deviceModes));

///////////////////////////////////////////////////////////////////////////////
TEST_P(HsFx3CtrlStallTest, InOut)
{
    ASSERT_TRUE(IsFx3Initialized());

    Fx3DeviceMode           fx3DeviceMode;

    fx3DeviceMode.connectSpeed              = GetParam().connectSpeed;
    fx3DeviceMode.interfaceBitmap           = GetParam().interfaceBitmap;

    FX3_LOG("Not testing for bMaxPacketSize0 < 64\n\r");
    FX3_LOG("FX3 cannot handle nMaxPacketSize < 64 at this time, please manually test these cases with known device.\n\r");
/*
    // bMaxPacketSize 8
    fx3DeviceMode.maxPacketSize                     = FX3_CTRL_MPS_8;

    Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
    PerformCtrlStallTest();

    // bMaxPacketSize 16
    fx3DeviceMode.maxPacketSize                     = FX3_CTRL_MPS_16;

    Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
    PerformCtrlStallTest();

    // bMaxPacketSize 32
    fx3DeviceMode.maxPacketSize                     = FX3_CTRL_MPS_32;

    Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
    PerformCtrlStallTest();
*/
    // bMaxPacketSize 64 for FS/HS, 512 fo SS: See deviceModes
    fx3DeviceMode.maxPacketSize                     = GetParam().maxPacketSize;

    Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
    PerformCtrlStallTest();
}


} // hs
} // usb
} // nnt

