﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/nn_Windows.h>
#include <winusb.h>
#include <memory>
#pragma warning(disable: 4668)
#include <setupapi.h>

#include "../../Common/UsbTestUtil.h"
#include "../../Common/UsbTestPcUtil.h"

namespace nnt {
namespace usb {
namespace ds {

UsbDsTestEnvironment* UsbTestEnv;
extern "C" void nninitStartup()
{
    NN_LOG("DsCancelPending Environment Setup..\n");

    ::testing::Environment* TestEnv = ::testing::AddGlobalTestEnvironment(new UsbDsTestEnvironment);
    UsbTestEnv = static_cast<UsbDsTestEnvironment*>(TestEnv);
}

enum
{
    TEST_ITERATIONS = 100,
    DATA_SIZE       = 4096 * 5,
};

unsigned char sendBuffer[DATA_SIZE];
unsigned char recvBuffer[DATA_SIZE];

TEST(DsCancelPendingTest, Read)
{
    UsbDevice *pDevice = UsbTestEnv->GetDevice();
    int iterations = TEST_ITERATIONS;

    while (iterations--)
    {
        pDevice->ReceiveDataSync(recvBuffer, DATA_SIZE, DATA_SIZE);
//        pDevice->SendDataSync(sendBuffer, DATA_SIZE, DATA_SIZE);
    }

    // This here to get rid of compiler warning
    MakeGaloisPattern(sendBuffer, DATA_SIZE, 1);
    CheckGaloisPattern(recvBuffer, DATA_SIZE, 1);
}

} // end of namespace ds
} // end of namespace usb
} // end of namespace nnt
