﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include "ToString.h"

namespace nnt { namespace usb { namespace pd {

    const char* ToString(bool value)
    {
        return value ? "True" : "False";
    }

    const char* ToString(nn::Result result) NN_NOEXCEPT
    {
        if (result.IsSuccess())
        {
            return "Success";
        }
        else
        {
            return "Failure";
        }
    }

    const char* ToString(nn::usb::pd::StatusPlugOrientation value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusPlugOrientation_Cc1:
            return "CC1";
        case nn::usb::pd::StatusPlugOrientation_Cc2:
            return "CC2";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusPowerRole value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusPowerRole_Sink:
            return "Sink";
        case nn::usb::pd::StatusPowerRole_Source:
            return "Source";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusDataRole value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusDataRole_Unknown:
            return "Unknown";
        case nn::usb::pd::StatusDataRole_Ufp:
            return "Ufp";
        case nn::usb::pd::StatusDataRole_Dfp:
            return "Dfp";
        case nn::usb::pd::StatusDataRole_AccessoryMode:
            return "AccessoryMode";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusAccessoryMode value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusAccessoryMode_Audio:
            return "Audio";
        case nn::usb::pd::StatusAccessoryMode_Debug:
            return "Debug";
        case nn::usb::pd::StatusAccessoryMode_None:
            return "None";
        case nn::usb::pd::StatusAccessoryMode_VConnPowered:
            return "VConnPowered";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusDeviceType value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusDeviceType_AcAdaptor:
            return "AcAdaptor";
        case nn::usb::pd::StatusDeviceType_Cradle:
            return "Cradle";
        case nn::usb::pd::StatusDeviceType_RelayBox:
            return "RelayBox";
        case nn::usb::pd::StatusDeviceType_TableDock:
            return "TableDock";
        case nn::usb::pd::StatusDeviceType_Unknown:
            return "Unknown";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusRequest value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusRequest_None:
            return "None";
        case nn::usb::pd::StatusRequest_PowerInput:
            return "PowerInput";
        case nn::usb::pd::StatusRequest_PowerOutput:
            return "PowerOutput";
        default:
            return "";
        }
    }

    const char* ToString(nn::usb::pd::StatusError value)
    {
        switch (value)
        {
        case nn::usb::pd::StatusError_CradleUsbHubUndetected:
            return "CradleUsbHubUndetected";
        case nn::usb::pd::StatusError_None:
            return "None";
        case nn::usb::pd::StatusError_OverVoltage:
            return "OverVoltage";
        default:
            return "";
        }
    }

    const char* ToString(nn::vi::HotplugState value)
    {
        switch (value)
        {
        case nn::vi::HotplugState_Disconnected:
            return "Disconnected";
        case nn::vi::HotplugState_Connected:
            return "Connected";
        default:
            return "";
        }
    }

    const char* ToString(nn::omm::OperationMode value)
    {
        switch (value)
        {
        case nn::omm::OperationMode::Console:
            return "Console";
        case nn::omm::OperationMode::Handheld:
            return "Handheld";
        default:
            return "";
        }
    }

    const char* ToString(nn::psm::ChargerType value)
    {
        switch (value)
        {
        case nn::psm::ChargerType_EnoughPower:
            return "EnoughPower";
        case nn::psm::ChargerType_LowPower:
            return "LowPower";
        case nn::psm::ChargerType_NotSupported:
            return "NotSupported";
        case nn::psm::ChargerType_Unconnected:
            return "Unconnected";
        default:
            return "";
        }
    }

    const char* ToString(State value)
    {
        switch(value)
        {
        case State_NoConnection:
            return "No connection";
        case State_OfficialAcAdaptor:
            return "Official AC adaptor";
        case State_AnkerMobileBattery:
            return "Anker 20100mAh mobile battery";
        case State_AnkerPowerPort:
            return "Anker 45W Type-C power port";
        case State_AppleCharger:
            return "Apple 61W charger";
        case State_GooglePixelCharger:
            return "Google Pixel 18W charger";
        case State_GoogleDualPowerPort:
            return "Google 22.5W lower power port on battery 90% or less EDEV";
        case State_RavpowerMobileBattery:
            return "Ravpower 26800mAh mobile battery on EDEV";
        case State_RavpowerMobileBatteryAfterWakeByBatterySaving:
            return "Ravpower 26800mAh mobile battery after wake trigger by battery saving mode on battery full EDEV without Joy-Con";
        case State_CradleWithNoAcAdaptor:
            return "Cradle (not powered)";
        case State_CradleWithOfficialAcAdaptor:
            return "Cradle (powered by official AC / HDMI unconnected)";
        case State_CradleWithHdmiTvOn:
            return "Cradle (powered by official AC / HDMI connected / TV ON)";
        case State_CradleWithAppleCharger:
            return "Cradle (powered by Apple 29W charger / HDMI connected / TV ON)";
        case State_CradleWithPc:
            return "Cradle (powered by PC)";
        case State_CradleOverVoltage:
            return "Cradle (over voltage)";
        case State_CradleOverVoltageAfterContract:
            return "Cradle (over voltage after power contract)";
        case State_RelayBoxWithNoAcAdaptor:
            return "Relay box (not powered)";
        case State_RelayBoxWithHdmiTvOn:
            return "Relay box (powered by official AC / HDMI connected / TV ON)";
        case State_RelayBoxWithAppleCharger:
            return "Relay box (powered by Apple 29W charger / HDMI connected / TV ON)";
        case State_RelayBoxWithPc:
            return "Relay box (powered by PC)";
        case State_TableDockWithNoAcAdaptor:
            return "Table dock in table mode (not powered)";
        case State_TableDockWithHdmiTvOn:
            return "Table dock in table mode (powered by official AC / HDMI connected / TV ON)";
        case State_TableDockWithAppleCharger:
            return "Table dock in table mode (powered by Apple 29W charger / HDMI connected / TV ON)";
        case State_TableDockWithGooglePixelCharger:
            return "Table dock in table mode (powered by Google Pixel 18W charger / HDMI connected / TV ON)";
        case State_TableDockWithPc:
            return "Table dock in table mode (powered by PC)";
        case State_TableDockOverVoltage:
            return "Table dock in table mode (over voltage)";
        case State_TableDockOverVoltageAfterContract:
            return "Table dock in table mode (over voltage after power contract)";
        case State_Pc:
            return "PC (via TypeA-C cable)";
        case State_Nx:
            return "NX (SDEV or EDEV / via TypeC-C cable)";
        case State_OverVoltage:
            return "Over voltage";
        case State_OverVoltageAfterContract:
            return "Over voltage after power contract";
        case State_UsbEther:
            return "Usb-Ether (via TypeA-C adaptor)";
        case State_UsbEtherAfterSleepWithRavpowerMobileBattery:
            return "Usb-Ether (via TypeA-C adaptor) after sleep with Ravpower 26800mAh mobile battery";
        default:
            return "";
        }
    }

}}}
