﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/usbPdUtil/testUsbPd_util.h>

namespace nnt { namespace usb { namespace pd {

    typedef enum
    {
        SceneType_Menu,
        SceneType_GetStatus,
        SceneType_GetNotice,
        SceneType_GetCradleVdo,
        SceneType_TestLed,
        SceneType_TestUsbHubReset,
        SceneType_StateTransition,
    } SceneType;

    typedef enum
    {
        SceneMenuType_Top,
        SceneMenuType_GetStatus,
        SceneMenuType_GetNotice,
    } SceneMenuType;

    typedef struct
    {
        SceneMenuType type;
    } SceneMenuArg;

    typedef struct
    {
        State state;
    } SceneGetNoticeArg;

    typedef struct
    {
        State state;
    } SceneGetStatusArg;

    typedef struct
    {
        SceneMenuArg menu;
        SceneGetNoticeArg getNotice;
        SceneGetStatusArg getStatus;
    } SceneArg;

    typedef struct
    {
        SceneType nextSceneType;
        SceneArg nextSceneArg;
    } SceneResult;
}}}
