﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Log.h>
#include <nv/nv_MemoryManagement.h>

#include <eval_Screen.h>

#include "Draw.h"

namespace {
    nnt::eval::Screen* g_pScreen;
    nn::gfx::util::DebugFontTextWriter* g_DebugFontTextWriter;

    // For nv::InitializeGraphics
    void* Allocate(size_t size, size_t alignment, void*)
    {
        return aligned_alloc(alignment, size);
    }

    void Free(void* addr, void*)
    {
        free(addr);
    }

    void* Reallocate(void* addr, size_t newSize, void*)
    {
        return realloc(addr, newSize);
    }
}

namespace nnt { namespace usb { namespace pd { namespace draw {

    void Initialize()
    {
        const size_t NvMemorySize = 8 * 1024 * 1024;
        nv::SetGraphicsAllocator(Allocate, Free, Reallocate, NULL);
        nv::SetGraphicsDevtoolsAllocator(Allocate, Free, Reallocate, NULL);
        nv::InitializeGraphics(std::malloc(NvMemorySize), NvMemorySize);

        g_pScreen = new ::nnt::eval::Screen();
        g_pScreen->Initialize();
        g_DebugFontTextWriter = g_pScreen->GetDebugFontTextWriterPtr();
    }

    void Clear()
    {
        g_DebugFontTextWriter->SetScale(1.2f, 1.2f);
        g_DebugFontTextWriter->SetCursor(20.0f, 20.0f);
    }

    void Draw()
    {
        g_pScreen->Draw();
    }

    void Print(const char* text, Color color)
    {
        switch(color)
        {
        case Color_Red:
            g_DebugFontTextWriter->SetTextColor({{255, 0, 0, 255}});
            break;
        case Color_Green:
            g_DebugFontTextWriter->SetTextColor({{0, 255, 0, 255}});
            break;
        default:
            g_DebugFontTextWriter->SetTextColor({{255, 255, 255, 255}});
            break;
        }
        g_DebugFontTextWriter->Print("%s\n", text);

        NN_LOG("%s\n", text);
    }

    void Finalize()
    {
        g_pScreen->Finalize();
        delete g_pScreen;
    }

}}}}
