﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Set environment variables for tests

    .DESCRIPTION
        Set environment variables for tests.
#>

param
(
    [Parameter(Mandatory=$false)]
    [string]
    # Path to PwrUSBDll.dll
    $DllPath = "C:\Program Files (x86)\PowerUSB\PwrUSBDll.dll",

    [Parameter(Mandatory=$false)]
    [int]
    # Time (seconds) of switch off
    $OnTime = 200,

    [Parameter(Mandatory=$false)]
    [int]
    # Time (seconds) of switch off
    $OffTime = 10,

    [Parameter(Mandatory=$false)]
    [int]
    # Time (seconds) to execute the script
    $ScriptExecutionTime = 8640000,

    [Parameter(Mandatory=$true)]
    [int]
    [ValidateRange(1, 3)]
    # Port number
    $PortNumber
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\..\..\..\Integrate\Scripts\Modules\PowerUsb"

Import-PowerUsbDll $DllPath
Initialize-PowerUsb

# $Time で指定した時間だけ、処理を続ける
$end = [DateTime]::Now.AddSeconds($ScriptExecutionTime)
while ([DateTime]::Now -lt $end)
{
    Set-PowerUsbPortState $PortNumber $true
    Sleep $OnTime
    Set-PowerUsbPortState $PortNumber $false
    Sleep $OffTime
}

Close-PowerUsb
