﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/uart/uart.h>

namespace nnt {
namespace uart {

/*
 * ターゲット上で利用可能な最初のポート番号を返します。
 */
int GetFirstAvailablePortIndex();

/*
 * バッファの中身を決まったパターンで埋めます。
 */
void GenerateTestData(char* data, size_t dataBytes);

/*
 * バッファの中身をクリアします。
 */
void ClearBuffer(char* data, size_t dataBytes);

/*
 * バイナリの内容を表示します。
 */
void DumpBinary(const char* pData, size_t dataBytes);

/*
 * テスト用のデータと実際のデータを比較します。
 */
bool CompareTestData(const char* pExpectedData, const char* pActualData, size_t dataBytes);

/*
 * 時限つきでバッファイベントを待機します。
 */
bool WaitBufferEvent(nn::uart::PortSession& portSession, nn::uart::PortEventType eventType, size_t threshold, nn::TimeSpan timeout);

/*
 * 送信バッファが空になるまで待機します。
 */
bool WaitSendBufferEmpty(nn::uart::PortSession& portSession, nn::TimeSpan timeout);

/*
 * 指定されたサイズのデータが受信可能になるまで待機します。
 */
bool WaitDataReady(nn::uart::PortSession& portSession, size_t expectedSize, nn::TimeSpan timeout);

/*
 * 指定されたサイズのデータを同期受信します。
 * 注: この関数は receiveDataCount がポートの受信バッファサイズ以下でなければ正常に機能しません。
 *     大きなデータの受信は ReceiveData() を使用してください。
 */
bool ReceiveDataSync(size_t* pDoneBytes, char* pOutBuffer, size_t receiveDataCount, nn::uart::PortSession& portSession, nn::TimeSpan timeout);

/*
 * バッファサイズを超えるような大きなデータをすべて送信します。基本的にフロー制御とセットで使ってください。
 */
bool SendData(nn::uart::PortSession& portSession, char* data, size_t dataBytes, size_t chunkSize, nn::TimeSpan interval);

/*
 * バッファサイズを超えるような大きなデータをすべて受信します。基本的にフロー制御とセットで使ってください。
 */
bool ReceiveData(nn::uart::PortSession& portSession, char* data, size_t dataBytes, size_t chunkSize, nn::TimeSpan interval);

} // uart
} // nnt
