﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

struct InputContext
{
    uint32_t    startFrame;
    uint8_t    *pBuffer;
};

class Input
{

public:

    void Initialize();
    void Finalize();

    bool IsAttached();

    nn::Result Start(nn::cduac::Host *pHost, nn::cduac::Parser *pParser, nn::cduac::InterfaceProfile *pInterfaceProfile);
    int16_t * GetInputFrame();

private:

    NN_ALIGNAS(4096) uint8_t    m_InputBuffer[BuffersCount][4096];
    InputContext                m_InputContext[BuffersCount];
    uint32_t                    m_InputBytes[MillisecondsPerFrameCount];
    nn::os::MutexType           m_Mutex;
    int8_t                      m_InputSamples[SamplesPerFrameCount * BytesPerSampleCount];
    uint32_t                    m_InputCounter;
    uint32_t                    m_InputFrames;
    uint32_t                    m_NextUsbFrame;
    nn::usb::XferReport         m_XferReport[MillisecondsPerFrameCount * BuffersCount];
    uint32_t                    m_OutCount;

    NN_ALIGNAS(4096) uint8_t    m_ThreadStack[16 * 1024];
    nn::os::ThreadType          m_Thread;
    bool                        m_ThreadIsUsed;
    bool                        m_IsAttached;

    nn::cduac::Host            *m_pHost;
    nn::cduac::Parser          *m_pParser;
    nn::cduac::Interface        m_Interface;

    Depop                       m_Depop;

    static void ReadThread(void *pContext);

    void Processing();
    void SetStartFrame();
    void PostTransferRequest();
    void CheckCompletions();
    void DepopFrame();
    void Resync();
};

