﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ZarfCreator.Parser;

namespace ZarfCreatorTest.WildcardPatternTest
{
    /// <summary>
    /// WildcardPatternTest の概要の説明
    /// </summary>
    [TestClass]
    public class WildcardPatternTest
    {
        public WildcardPatternTest()
        {
            //
            // TODO: コンストラクター ロジックをここに追加します
            //
        }

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        //
        // テストを作成する際には、次の追加属性を使用できます:
        //
        // クラス内で最初のテストを実行する前に、ClassInitialize を使用してコードを実行してください
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // クラス内のテストをすべて実行したら、ClassCleanup を使用してコードを実行してください
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // 各テストを実行する前に、TestInitialize を使用してコードを実行してください
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // 各テストを実行した後に、TestCleanup を使用してコードを実行してください
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        /// <summary>
        /// ワイルドカード無しのテスト
        /// </summary>
        [TestMethod]
        public void TestMethod1()
        {
            var pattern = new WildcardPattern(new[] { "init.h" });
            Assert.IsTrue(pattern.IsMatch("init.h"));
            Assert.IsTrue(pattern.IsMatch("INIT.H"));          // 大文字小文字を無視する。

            Assert.IsFalse(pattern.IsMatch("init.c"));
            Assert.IsFalse(pattern.IsMatch("sinit.h"));
        }

        /// <summary>
        /// '*'のテスト
        /// </summary>
        [TestMethod]
        public void TestMethod2()
        {
            var pattern = new WildcardPattern(new[] { "*.h" });
            Assert.IsTrue(pattern.IsMatch(".h"));              // 0文字以上に一致
            Assert.IsTrue(pattern.IsMatch("init.h"));

            Assert.IsFalse(pattern.IsMatch("init.c"));
            Assert.IsFalse(pattern.IsMatch("init.hh"));

            Assert.IsFalse(pattern.IsMatch("nn/.h"));      // '/' は任意の文字としない。
            Assert.IsFalse(pattern.IsMatch(@"nn\.h"));     // '\' は任意の文字としない。
        }

        /// <summary>
        /// '?'のテスト
        /// </summary>
        [TestMethod]
        public void TestMethod3()
        {
            var pattern = new WildcardPattern(new[] { "init.?" });
            Assert.IsTrue(pattern.IsMatch("init.h"));
            Assert.IsFalse(pattern.IsMatch("init."));       // 0文字とは一致しない
            Assert.IsFalse(pattern.IsMatch("init.hh"));     // 1文字を超える文字数とも一致しない
            Assert.IsFalse(pattern.IsMatch("init./"));      // '/'と一致しない
        }

        /// <summary>
        /// '**'のテスト('**'のみ)
        /// </summary>
        [TestMethod]
        public void TestMethod4()
        {
            var pattern = new WildcardPattern(new[] { "**" });
            Assert.IsTrue(pattern.IsMatch("init.h"));
            Assert.IsTrue(pattern.IsMatch("nn/fs.h"));
        }

        /// <summary>
        /// '**'のテスト(後続に'/～'が続く)
        /// </summary>
        [TestMethod]
        public void TestMethod5()
        {
            var pattern = new WildcardPattern(new[] { "**/*.h" });
            Assert.IsTrue(pattern.IsMatch("init.h"));                           // 0個のディレクトリと一致
            Assert.IsTrue(pattern.IsMatch("nn/fs.h"));                          // 1個のディレクトリと一致
            Assert.IsTrue(pattern.IsMatch("nn/fs/fs_File.h"));                  // 2個のディレクトリと一致
            Assert.IsTrue(pattern.IsMatch("nn/diag/detail/diag_DetailLog.h"));  // 3個のディレクトリと一致
        }

        /// <summary>
        /// '**'のテスト(前に'～/'があり、後続に'/～'が続く)
        /// </summary>
        [TestMethod]
        public void TestMethod6()
        {
            var pattern = new WildcardPattern(new[] { "nn/**/*.h" });
            Assert.IsTrue(pattern.IsMatch("nn/fs.h"));                          // 0個のディレクトリと一致
            Assert.IsTrue(pattern.IsMatch("nn/fs/fs_File.h"));                  // 1個のディレクトリと一致
            Assert.IsTrue(pattern.IsMatch("nn/diag/detail/diag_DetailLog.h"));  // 2個のディレクトリと一致

            Assert.IsFalse(pattern.IsMatch("init.h"));
        }

        /// <summary>
        /// '**'のテスト(前に'～/'がある)
        /// </summary>
        [TestMethod]
        public void TestMethod7()
        {
            var pattern = new WildcardPattern(new[] { "nn/**" });
            TestWildcardCommon(pattern);
        }

        /// <summary>
        /// '/'で終わる場合のテスト
        /// nn/** と同じになる
        /// </summary>
        [TestMethod]
        public void TestMethod8()
        {
            var pattern = new WildcardPattern(new[] { "nn/" });
            TestWildcardCommon(pattern);
        }

        private static void TestWildcardCommon(WildcardPattern pattern)
        {
            Assert.IsTrue(pattern.IsMatch("nn/fs.h"));
            Assert.IsTrue(pattern.IsMatch("nn/fs/fs_File.h"));
            Assert.IsTrue(pattern.IsMatch("nn/fs.cpp"));

            Assert.IsFalse(pattern.IsMatch("init.h"));
        }
    }
}
