﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ZarfCreator.Parser;

namespace ZarfCreatorTest.ParserTest
{
    [TestClass]
    public class RollbackPaserTest
    {
        [TestMethod]
        public void ParseSuccessTest1()
        {
            var parser = new RollbackParser();

            var data = new Dictionary<string, object>()
            {
                { "TrackFiles", new List<object>()
                    {
                        "NintendoSDK/Include/**/*.h",
                        "NintendoSDK/Samples/"
                    }
                }
            };

            var result = parser.Parse(data);

            CollectionAssert.AreEquivalent(
                new string[] { "NintendoSDK/Include/**/*.h", "NintendoSDK/Samples/" },
                result.TrackFilePatternList.ToArray());
        }

        /// <summary>
        /// typo している場合
        /// </summary>
        [TestMethod]
        public void ParseFailByTypographicalErrorTest()
        {
            var parser = new RollbackParser();

            Console.Error.WriteLine("---");
            var data1 = new Dictionary<string, object>()
            {
                { "Trackfiles", new List<object>()
                    {
                        "NintendoSDK/Include/**/*.h",
                        "NintendoSDK/Samples/"
                    }
                }
            };

            TestUtil.ExpectException<FormatException>(() => parser.Parse(data1), "Unknown key was specified.");
        }
    }
}
