﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using ZarfCreator.Parser;
using System.Collections;
using System.Linq;

namespace ZarfCreatorTest.ParserTest
{
    [TestClass]
    public class RelatedZarfParseTest
    {
        [TestMethod]
        public void ParseSuccessTest1()
        {
            var parser = new RelatedZarfParser();

            var data1 = new Dictionary<string, object>()
            {
                {"Target", "TargetZarf"}
            };

            var result = parser.Parse(data1);

            Assert.AreEqual(result.Target, "TargetZarf");


            var data2 = new Dictionary<string, object>()
            {
                {"Target", "Target ZarfDefinition"},
                {"Versions", new List<object>()
                    {
                        "0.3.0"
                    }
                }
            };

            result = parser.Parse(data2);

            Assert.AreEqual(result.Target, "Target ZarfDefinition");
            CollectionAssert.AreEquivalent(result.VersionSource.ToList(), new List<string>() { "0.3.0" });


            var data3 = new Dictionary<string, object>()
            {
                {"Target", "Integrate/Package/TargetZarfDefinition.yml"},
                {"Versions", new List<object>()
                    {
                        "0.3.0",
                        "0.0.1.2"
                    }
                }
            };

            result = parser.Parse(data3);

            Assert.AreEqual(result.Target, "Integrate/Package/TargetZarfDefinition.yml");
            CollectionAssert.AreEquivalent(result.VersionSource.ToList(),
                new List<string>() { "0.3.0", "0.0.1.2" });
        }

        /// <summary>
        /// 必要な要素が足りない場合のテスト
        /// </summary>
        [TestMethod]
        public void ParseFailByNotMeetRequirementsTest()
        {
            var parser = new RelatedZarfParser();

            Console.Error.WriteLine("---");
            var data1 = new Dictionary<string, object>()
            {
            };

            TestUtil.ExpectException<FormatException>(() => parser.Parse(data1), "Required items have not been completed.");

            Console.Error.WriteLine("---");
            var data3 = new Dictionary<string, object>()
            {
                {"Target", "test"},
                {"Versions", new List<string>()}
            };

            TestUtil.ExpectException<InvalidCastException>(() => parser.Parse(data3));
        }

        /// <summary>
        /// typo していた場合のテスト
        /// </summary>
        [TestMethod]
        public void ParseFailByTypographicalErrorTest()
        {
            var parser = new RelatedZarfParser();

            Console.Error.WriteLine("---");
            var data = new Dictionary<string, object>()
            {
                { "Targets", "test"}
            };

            TestUtil.ExpectException<FormatException>(() => parser.Parse(data), "Unknown key was specified.");

            Console.Error.WriteLine("---");
            var data2 = new Dictionary<string, object>()
            {
                { "Target", "test"},
                { "Version", new List<string>()
                    {
                        "0.8.0"
                    }
                }
            };
            TestUtil.ExpectException<FormatException>(() => parser.Parse(data2), "Unknown key was specified.");
        }
    }
}
