﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VsSolutionLibraryTest
{
    internal class TestUtility
    {
        /// <summary>
        /// ソリューションのテキストを比較するためのメソッド。
        /// 行頭・行末のタブ・空白をカットし、大文字と小文字の違いを無視して比較を行う。
        /// </summary>
        /// <param name="lhs"></param>
        /// <param name="rhs"></param>
        /// <returns>テキストが一致していたら true / 不一致なら false</returns>
        public static bool CompareSolutionString(string lhs, string rhs)
        {
            return Enumerable.SequenceEqual(
                IgnoreWhiteSpaceSequence(lhs),
                IgnoreWhiteSpaceSequence(rhs),
                StringComparer.InvariantCultureIgnoreCase);
        }

        private static IEnumerable<string> IgnoreWhiteSpaceSequence(string source)
        {
            return (source ?? string.Empty)
                .Split(new[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries)
                .Select(x => x.Trim())
                .Where(x => !string.IsNullOrWhiteSpace(x));
        }

        /// <summary>
        /// 2つのコレクションを集合として比較
        /// </summary>
        /// <typeparam name="T">引数のコレクションの型</typeparam>
        /// <param name="lhs">左辺値</param>
        /// <param name="rhs">右辺値</param>
        /// <returns>2つのコレクションが集合と一致していたら true / 不一致なら false</returns>
        public static bool CompareAsSet<T>(IEnumerable<T> lhs, IEnumerable<T> rhs)
        {
            if (lhs == null)
            {
                return (rhs == null);
            }

            return (lhs.Except(rhs).Count() == 0);
        }
    }
}
